<?php
    include("../include.php");
    require_once('../../order/fpdf/fpdf.php');
	
	$customer_list = array();
    $customer_list = $obj->getTableRecords($GLOBALS['customer_table'], '', '');

    $company_list = array();
    $company_list = $obj->getTableRecords($GLOBALS['company_table'], '', '');

    foreach($company_list as $data){
        $company_name = ""; $company_address = ""; $company_mobile = ""; $company_email = ""; $logo = "";

        if(!empty($data['name'])) {
            $company_name = $obj->encode_decode('decrypt', $data['name']);
        }
        if(!empty($data['logo']) && $data['logo'] != $GLOBALS['null_value']) {
            $logo = $data['logo'];
        }
        if(!empty($data['address']) && $data['address'] != $GLOBALS['null_value']) {
            $company_address = $obj->encode_decode('decrypt', $data['address']);
        }
        if(!empty($data['mobile_number'])) {
            $company_mobile = $obj->encode_decode('decrypt', $data['mobile_number']);
        }
        if(!empty($data['email'])) {
            $company_email = $obj->encode_decode('decrypt', $data['email']);
        }
    }

    $logo = "../../images/logo.png";

    
    $pdf = new FPDF('P','mm','A4');
    $pdf->AliasNbPages(); 
    $pdf->AddPage();
    $pdf->SetAutoPageBreak(true);
    $pdf->SetTitle('Customer List');
    $pdf->SetFont('Arial','B',10);
    $pdf->SetY(10);
    $pdf->Cell(0,5,strtoupper($company_name),0,1,'C',0);
    $pdf->SetFont('Arial','',7);
    $pdf->Cell(0,4,$company_address,0,1,'C',0);
    $pdf->Cell(0,4,'E-mail : '.$company_email.'   Phone : '.$company_mobile,0,1,'C',0);

    if(!empty($logo)){
        $pdf->Image($logo,10,7,25,20);
    }
    
    $pdf->SetY(7);
    $pdf->Cell(0,20,'',1,1,'L',0);
    $pdf->SetFont('Arial','B',9);
    $pdf->Cell(0,6,'CUSTOMER LIST',1,1,'C',0);
    $pdf->SetFont('Arial','B',8);
    $pdf->SetX(10);
    $pdf->Cell(15,5,'S.No',1,0,'C',0);
    $pdf->SetX(25);
    $pdf->Cell(50,5,'Customer Name',1,0,'C',0);
    $pdf->SetX(75);
    $pdf->Cell(25,5,'Mobile Number',1,0,'C',0);
    $pdf->SetX(100);
    $pdf->Cell(40,5,'Address',1,0,'C',0);
    $pdf->SetX(140);
    $pdf->Cell(30,5,'City',1,0,'C',0);
    $pdf->SetX(170);
    $pdf->Cell(30,5,'State',1,1,'C',0);
    $pdf->SetFont('Arial','',8);

    if(!empty($customer_list)) {
        $sno = 1;
        foreach($customer_list as $data) {
            if($pdf->GetY()>260){
                $pdf->AddPage();
                $pdf->SetFont('Arial','B',10);
                $pdf->SetY(10);
                $pdf->Cell(0,5,strtoupper($company_name),0,1,'C',0);
                $pdf->SetFont('Arial','',7);
                $pdf->Cell(0,4,$company_address,0,1,'C',0);
                $pdf->Cell(0,4,'E-mail : '.$company_email.'   Phone : '.$company_mobile,0,1,'C',0);

                if(!empty($logo)){
                    $pdf->Image($logo,10,7,25,20);
                }
                
                $pdf->SetY(7);
                $pdf->Cell(0,20,'',1,1,'L',0);
                $pdf->SetFont('Arial','B',9);
                $pdf->Cell(0,6,'CUSTOMER LIST',1,1,'C',0);
                $pdf->SetFont('Arial','B',8);
                $pdf->SetX(10);
                $pdf->Cell(15,5,'S.No',1,0,'C',0);
                $pdf->SetX(25);
                $pdf->Cell(50,5,'Customer Name',1,0,'C',0);
                $pdf->SetX(75);
                $pdf->Cell(25,5,'Mobile Number',1,0,'C',0);
                $pdf->SetX(100);
                $pdf->Cell(40,5,'Address',1,0,'C',0);
                $pdf->SetX(140);
                $pdf->Cell(30,5,'City',1,0,'C',0);
                $pdf->SetX(170);
                $pdf->Cell(30,5,'State',1,1,'C',0);
                $pdf->SetFont('Arial','',8);
            }
            if(!empty($data['name'])) {
                $yaxis = $pdf->GetY();
                $pdf->SetX(10);
                $pdf->Cell(15,5,$sno,0,0,'C',0);
                $pdf->SetX(25);
                $data['name'] = $obj->encode_decode('decrypt',$data['name']);
                $pdf->MultiCell(50,5,$data['name'],0,'L',0);
                $yaxis1 = $pdf->GetY();
                $pdf->SetY($yaxis);
                $pdf->SetX(75);
                $pdf->Cell(25,5,$obj->encode_decode('decrypt',$data['mobile_number']),0,0,'C',0);
                $pdf->SetX(100);
                if(!empty($data['address'])) {
                    $data['address'] = $obj->encode_decode('decrypt', $data['address']);
                    $data['address'] = str_replace("\r\n", ", ", $data['address']);
                    $data['address'] = str_replace("<br>", " ", $data['address']);
                }
                $pdf->MultiCell(40,5,$data['address'],0,'C',0);
                $yaxis2 = $pdf->GetY();
                $pdf->SetY($yaxis);
                if($data['city'] != $GLOBALS['null_value']) {
                    $data['city'] = $obj->encode_decode('decrypt', $data['city']);
                }
                else {
                    $data['city'] = "";
                }
                $pdf->SetX(140);
                $pdf->MultiCell(30,5,$data['city'],0,'C',0);
                $yaxis3 = $pdf->GetY();
                $pdf->SetY($yaxis);
                $data['state'] = $obj->encode_decode('decrypt', $data['state']);
                $pdf->SetX(170);
                $pdf->MultiCell(30,5,$data['state'],0,'C',0);
                $yaxis4 = $pdf->GetY();
                

                // $pdf->Cell(25,5,'',0,1,'C',0);

                $height = 5; $y="";
                if($yaxis1>$yaxis2 && $yaxis1>$yaxis3 && $yaxis1>$yaxis4){
                    $height = $yaxis1 - $yaxis;
                }
                else if($yaxis2>$yaxis1 && $yaxis2>$yaxis3 && $yaxis2>$yaxis4){
                    $height = $yaxis2 - $yaxis;
                }
                else if($yaxis3>$yaxis4 && $yaxis3>$yaxis1 && $yaxis3>$yaxis2){
                    $height = $yaxis3 - $yaxis;
                }
                else if($yaxis4>$yaxis1 && $yaxis4>$yaxis2 && $yaxis4>$yaxis3){
                    $height = $yaxis4 - $yaxis;
                }
                $pdf->SetY($yaxis);
                $pdf->SetX(10);
                $pdf->Cell(15,$height,'',1,0,'C',0);
                $pdf->SetX(25);
                $pdf->Cell(50,$height,'',1,0,'C',0);
                $pdf->SetX(75);
                $pdf->Cell(25,$height,'',1,0,'C',0);
                $pdf->SetX(100);
                $pdf->Cell(40,$height,'',1,0,'C',0);
                $pdf->SetX(140);
                $pdf->Cell(30,$height,'',1,0,'C',0);
                $pdf->SetX(170);
                $pdf->Cell(30,$height,'',1,1,'C',0);

                $sno++;
            }
        }
    }
    
    $pdf->SetY(-10);
    $pdf->Cell(0, 5, "Page " . $pdf->PageNo() . "/{nb}", 0, 1,'C',0);

    $pdf->Output();
?>