<?php 
    if(!empty($device_layout) && $device_layout == "desktop") { 
        include("order/cart_desktop.php");
    }
?>
<div class="w-100">
	<div class="container-fluid pt-2">
        <?php
            $product_row_count = 0; $product_limit = 0; $empty_product_row_count = 0; $image_prefix = "";
            if(!empty($device_layout)) {
                if($device_layout == "desktop") {
                    $product_row_count = $obj->getTableColumnValue($GLOBALS['settings_table'], 'name', 'desktop_box_count', 'value');
                    if(empty($product_row_count)) {
                        $product_row_count = 8;
                        $empty_product_row_count = 1;
                    }
                    if($product_row_count == 8) { $product_limit = 4; }
                    if($product_row_count == 6) { $product_limit = 3; }                    
                }
                if($device_layout == "tablet") {
                    $product_row_count = 4; $product_limit = 4;
                }
                if($device_layout == "mobile") {
                    $product_row_count = 2; $product_limit = 2;
                }
            }

            if(!empty($product_limit)) {
                if($product_limit == "2" || $product_limit == "3") {
                    $image_prefix = "box_3";
                }
                else if($product_limit == "4") {
                    $image_prefix = "box_4";
                }
            }

            if(!empty($pricelist)) {
                foreach($pricelist as $row1) {
                    if(!empty($row1['category_id'])) {
                        $category_name = ""; $category_id = $row1['category_id'];
                        if(!empty($row1['category_name'])) {
                            $category_name = $obj->encode_decode('decrypt', $row1['category_name']);
                        }

                        $category_discount = 0;
                        if(!empty($row1['discount'])) {
                            $category_discount = $row1['discount'];
                        }

                        $category_product_count = 0; $category_product_list = array();
                        if(!empty($row1['product_list'])) {
                            $category_product_count = count($row1['product_list']);
                            $category_product_list = $row1['product_list'];
                        }    
        ?>
                        <div class="row">
                            <div class="col-lg-12 fullpad">
                                <div id="view_category_<?php echo $category_id; ?>" class="category-para category-bg">
                                    <div class="category-bg py-2 medium pl-3">
                                        <?php 
                                            if(!empty($category_name)) { 
                                                echo $category_name; 
                                                if(!empty($category_discount)) { echo " (".$category_discount."% Discount)"; } 
                                                else { echo " (Net Rate Products)"; }
                                            } 
                                        ?>
                                    </div>
                                </div>
                            </div>
                            <?php
                                $column_count = 0;
                                if(!empty($category_product_count) && !empty($product_row_count)) {
                                    if($category_product_count <= $product_limit) {
                                        $column_count = 1;
                                        if(!empty($empty_product_row_count) && $empty_product_row_count == 1) {
                                            $product_limit = 4;
                                        }
                                    }
                                    else {
                                        $column_count = ceil($category_product_count / $product_limit);
                                    }
                                }
                                //echo "column_count - ".$column_count.", category_product_count - ".$category_product_count.", product_row_count - ".$product_row_count.", product_limit - ".$product_limit;
                                if(!empty($column_count)) {
                                    $sno = 0; $no_of_boxes = $product_limit; $product_list = array(); $product_row_name = array();;
                                    for($i = 1; $i <= $column_count; $i++) {
                                        if(!empty($no_of_boxes)) {
                                            $products_by_row = array();
                                            for($j = 1; $j <= $no_of_boxes; $j++) {
                                                if(!empty($category_product_list[$sno])) {
                                                    $products_by_row[] = $category_product_list[$sno];
                                                    
                                                    $index = $sno + 1;
                                                    if($index % 2 == 0) {
                                                        $product_row_name[] = "product_row2";
                                                    }
                                                    else {
                                                        $product_row_name[] = "product_row1";
                                                    }

                                                    $sno++;
                                                }
                                            }
                                            $product_list[] = $products_by_row;
                                        } 
                                        $balance_boxes = 0;
                                        $balance_boxes = $category_product_count - $product_limit;
                                        if($balance_boxes > $product_limit) {
                                            $no_of_boxes = $product_limit;
                                        }
                                        else {
                                            $no_of_boxes = $balance_boxes;
                                        }
                                    }

                                    $sno = 0;
                                    for($i = 1; $i <= $column_count; $i++) {
                                        $products_by_row = "";
                                        if(!empty($product_list[$i - 1])) {
                                            $products_by_row = $product_list[$i - 1];
                                        }
                            ?>
                                        <div class="col-lg-6">
                                            <?php //echo "category_product_count - ".$category_product_count.", product_limit - ".$product_limit.", column_count - ".$column_count; ?>
                                            <div class="row my-2">
                                            <?php 
                                                foreach($products_by_row as $data) {
                                                    if(!empty($data['product_id'])) {
                                                        $product_name = ""; $product_id = $data['product_id'];
                                                        if(!empty($data['name'])) {
                                                            $product_name = $obj->encode_decode('decrypt', $data['name']);
                                                            $product_name = str_replace("$$", '"', $product_name);
                                                            $product_name = str_replace("$", "'", $product_name);
                                                        }
                                                        $product_video = "";
                                                        if(!empty($data['product_video']) && $data['product_video'] != $GLOBALS['null_value']) {
                                                            $product_video = $data['product_video'];
                                                        }
                                                        $product_image = "";
                                                        if(!empty($data['product_image']) && $data['product_image'] != $GLOBALS['null_value']) {
                                                            $product_image = $data['product_image'];
                                                            if(!empty($product_image) && !empty($image_prefix)) {
                                                                $product_image = $image_prefix."_".$product_image;
                                                            }
                                                        }
                                                        $actual_price = 0; $discounted_price = 0;

                                                        if(!empty($product_price_display_format)) {
                                                            if($product_price_display_format == 1) {
                                                                if(!empty($data['price'])) {
                                                                    $actual_price = $data['price'];
                                                                    if(!empty($category_discount)) {
                                                                        $discounted_value = 0;
                                                                        $discounted_value = ($actual_price * $category_discount) / 100;
                                                                        if(!empty($discounted_value)) {
                                                                            $discounted_value = number_format($discounted_value, 2);
                                                                            $discounted_value = str_replace(",", "", $discounted_value);
                                                                            $discounted_price = $actual_price - $discounted_value;
                                                                        }
                                                                    }
                                                                    else {
                                                                        $discounted_price = $actual_price;
                                                                    }
                                                                }
                                                            }
                                                            else if($product_price_display_format == 2) {
                                                                if(!empty($data['price'])) {
                                                                    $discounted_price = $data['price'];
                                                                    if(!empty($discounted_price)) {
                                                                        if(!empty($category_discount) && !empty($discounted_price)) {
                                                                            $actual_price = $obj->getActualPrice($discounted_price, $category_discount);
                                                                        }
                                                                        else {
                                                                            $actual_price = $discounted_price;   
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        
                                                        $product_content = "";
                                                        if(!empty($data['product_content'])) {
                                                            $product_content = $obj->encode_decode('decrypt', $data['product_content']);
                                                        }
                                                        $product_code = "";
                                                        if(!empty($data['product_code']) && $data['product_code'] != $GLOBALS['null_value']) {
                                                            $product_code = $obj->encode_decode('decrypt', $data['product_code']);
                                                        }

                                                        $box_width = 0;
                                                        if($product_limit == 4) { $box_width = 3; }
                                                        if($product_limit == 3) { $box_width = 4; }

                                                        $product_row = "";
                                                        if(!empty($product_row_name[$sno])) {
                                                            $product_row = $product_row_name[$sno];
                                                        }
                                            ?>
                                                        <div class="col-6 col-md-<?php echo $box_width; ?> product_cover_<?php if(!empty($product_id)) { echo $product_id; } ?>">
                                                            <div class="pricelist_product_row_cover mb-3 <?php if(!empty($product_row)) { echo $product_row; } ?>">
                                                                <div class="w-100" onClick="Javascript:ShowProductImageVideo('<?php if(!empty($product_id)) { echo $product_id; } ?>', '<?php if(!empty($data['product_video_id'])) { echo $data['product_video_id']; } ?>');" id="<?php if(!empty($data['product_video_id'])) { echo $data['product_video_id']; } ?>" style="cursor: pointer; text-align: center; position: relative;">
                                                                    <?php if(!empty($show_product_code) && $show_product_code == 1) { ?>
                                                                        <?php if(!empty($product_code)) { ?>
                                                                        <div class="box_sno"><span><?php echo $product_code; ?></span></div>
                                                                        <?php } ?>
                                                                    <?php } ?>
                                                                    <?php if(!empty($product_video)) { ?>
                                                                    <div class="ribbons red"><span>Video</span></div>
                                                                    <?php } ?>

                                                                    <div class="box_product_image">
                                                                    <?php if(!empty($product_image) && file_exists($target_dir.$product_image)) { ?>
                                                                        <img src="<?php echo $target_dir.$product_image; ?>" class="img-fluid pb-2" alt="<?php if(!empty($product_name)) { echo htmlentities($product_name); } ?>" title="<?php if(!empty($product_name)) { echo htmlentities($product_name); } ?>">
                                                                    <?php } /*else { ?>
                                                                        <img src="order/images/no-image.jpg" class="img-fluid pb-2" alt="<?php if(!empty($product_name)) { echo htmlentities($product_name); } ?>" title="<?php if(!empty($product_name)) { echo htmlentities($product_name); } ?>">
                                                                    <?php }*/ ?>
                                                                    </div>

                                                                    <?php
                                                                        /*if(!empty($data['sub_images']) && $data['sub_images'] != $GLOBALS['null_value']) {
                                                                            foreach($data['sub_images'] as $sub_image) {
                                                                                if(!empty($sub_image) && file_exists($target_dir.$sub_image)) {
                                                                    ?>
                                                                                    <input type="hidden" name="sub_images" value="<?php echo $target_dir.$sub_image; ?>">
                                                                    <?php
                                                                                }
                                                                            } 
                                                                        }*/
                                                                    ?>
                                                                </div>
                                                                <div class="row pt-2 mx-2">
                                                                    <div class="col-12 px-1">
                                                                        <?php if(!empty($product_name)) { ?>
                                                                        <div class="medium fnt1 pb-2 box_product_name"><?php echo $product_name; ?></div>
                                                                        <?php } ?>
                                                                    </div>
                                                                    <div class="col-6 px-1 row mx-0 align-items-center">
                                                                        <?php if(!empty($category_discount)) { ?>
                                                                        <div class="medium pb-2 strike">
                                                                            <i class="bi bi-currency-rupee"></i> <?php if(!empty($actual_price)) { echo $actual_price; } ?>
                                                                        </div>
                                                                        <?php } ?>
                                                                    </div>
                                                                    <div class="col-6 px-1 text-right">
                                                                        <div class="product_quantity_cover_<?php if(!empty($product_id)) { echo $product_id; } ?>">
                                                                            <a href="Javascript:AddProduct('<?php if(!empty($product_id)) { echo $product_id; } ?>');" class="transparent-blue-button2 medium"><i class="bi bi-plus-plus"></i> &nbsp; Add </a>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-12 px-1">                                                                       
                                                                        <div class="medium fnt2">
                                                                            <i class="bi bi-currency-rupee"></i> 
                                                                            <span class="product_price"><?php if(!empty($discounted_price)) { echo $discounted_price; } ?></span>
                                                                            / <?php if(!empty($product_content)) { echo $product_content; } ?>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>    
                                                        </div>
                                            <?php
                                                        $sno++;
                                                    }    
                                                }
                                            ?>
                                            </div>
                                        </div>
                            <?php
                                    }
                                }
                            ?>
                        </div>
        <?php
                    }
                }
            }        
        ?>
	</div>
</div>

<?php 
    if(!empty($device_layout) && $device_layout != "desktop") { 
        include("order/cart.php");
    }
?>