<?php
	include("include.php");
	
	if(isset($_REQUEST['add_customer'])) {
        $add_customer = $_REQUEST['add_customer'];
		$customer_id = $_REQUEST['customer_id'];
        if(!empty($add_customer) && $add_customer == 1) {
            $state_list = array();
            $state_list = $obj->DisplayCustomerStates();

			$default_state = $obj->encode_decode('encrypt', 'Tamil Nadu');

			$name = ""; $mobile_number = ""; $email = ""; $address = ""; $customer_city = "";
			if(!empty($customer_id)) {
				$customer_list = array();
				$customer_list = $obj->getTableRecords($GLOBALS['customer_table'], 'customer_id', $customer_id);
				if(!empty($customer_list)) {
					foreach($customer_list as $data) {
						if(!empty($data['name'])) {
							$name = $obj->encode_decode('decrypt', $data['name']);
						}
						if(!empty($data['mobile_number'])) {
							$mobile_number = $obj->encode_decode('decrypt', $data['mobile_number']);
						}
						if(!empty($data['email']) && $data['email'] != $GLOBALS['null_value']) {
							$email = $obj->encode_decode('decrypt', $data['email']);
						}
						if(!empty($data['address'])) {
							$address = $obj->encode_decode('decrypt', $data['address']);
							$address = str_replace("<br>", "\r\n", $address);
						}
						if(!empty($data['city'])) {
							$customer_city = $data['city'];
						}
						if(!empty($data['state'])) {
							$default_state = $data['state'];
						}
					}
				}
			}

			$city_list = array();
            $city_list = $obj->DisplayCitiesByState($default_state);
?>
            <form class="py-4 poppins pd-20 col-xl-8 mx-auto" name="customer_form" method="POST">
				<input type="hidden" name="customer_id" value="<?php if(!empty($customer_id)) { echo $customer_id; } ?>">
                <div class="row add_update_form_content">
                    <div class="form-group col-sm-6">
                        <div class="form-label-group in-border mb-0">
                            <select name="state" class="form-control" onChange="javascript:changeCity(this.value);">
                                <option value="">Select State</option>
                                <?php
                                    if(!empty($state_list)) {
                                        foreach($state_list as $data) {
                                            if(!empty($data['state'])) {
                                ?>
                                                <option value="<?php if(!empty($data['state'])) { echo $data['state']; } ?>" <?php if(!empty($default_state) && $data['state'] == $default_state) { ?> selected <?php } ?> >
                                                    <?php
                                                        if(!empty($data['state'])) {
                                                            $data['state'] = $obj->encode_decode('decrypt', $data['state']);
                                                            echo $data['state'];
                                                        }
                                                    ?>
                                                </option>
                                <?php     
                                            }       
                                        }
                                    }
                                ?>
                            </select>
                            <label>State (*)</label>
                        </div>
                    </div>
                    <div class="form-group col-sm-6">
                        <div id="city_list" class="form-label-group in-border mb-0">
                            <select name="city" class="form-control">
                                <option value="">Select City</option>
                                <?php
                                    if(!empty($city_list)) {
                                        foreach($city_list as $city) {
                                            if(!empty($city)) {
                                ?>
                                                <option value="<?php if(!empty($city)) { echo $obj->encode_decode('encrypt', $city); } ?>" <?php if(!empty($customer_city) && $obj->encode_decode('encrypt', $city) == $customer_city) { ?> selected <?php } ?> >
                                                    <?php if(!empty($city)) { echo $city; } ?>
                                                </option>
                                <?php     
                                            }       
                                        }
                                    }
                                ?>
                            </select>
                            <label>City (*)</label>
                        </div>
                    </div>
                    <div class="form-group col-12">
                        <div class="form-label-group in-border mb-0">
                            <input type="text" name="name" value="<?php if(!empty($name)) { echo $name; } ?>" class="form-control shadow-none" placeholder="Customer Name">
                            <label>Name (*)</label>
                        </div>
                    </div>
                    <div class="form-group col-sm-6">
                        <div class="form-label-group in-border mb-0">
                            <input type="text" name="mobile_number" value="<?php if(!empty($mobile_number)) { echo $mobile_number; } ?>" class="form-control shadow-none" placeholder="Mobile Number">
                            <label>Mobile Number (*)</label>
                        </div>
                    </div>
                    <div class="form-group col-sm-6">
                        <div class="form-label-group in-border mb-0">
                            <input type="text" name="email" value="<?php if(!empty($email)) { echo $email; } ?>" class="form-control shadow-none" placeholder="Email">
                            <label>Email</label>
                        </div>
                    </div>
                    <div class="form-group col-12">
                        <div class="form-label-group in-border mb-0">
                            <textarea name="address" class="form-control" placeholder="Address" rows="4"><?php if(!empty($address)) { echo $address; } ?></textarea>
                            <label>Address (*)</label>
                        </div>
                    </div>
                    <div class="col-md-12 pt-3 text-center">
                        <button class="btn btn-primary btnwidth submit_button" type="button" onClick="Javascript:SaveCustomer('customer_form');">Submit</button>
                    </div>
                </div>
                <script type="text/javascript">
                    jQuery(document).ready(function(){
						jQuery('form[name="customer_form"]').find('select').select2({ dropdownParent: jQuery('#AddCustomermodal') });
                    });    
                </script>
            </form>
<?php
        }        
    }

	if(isset($_REQUEST['diplay_city_by_state'])) {
		$diplay_city_by_state = $_REQUEST['diplay_city_by_state'];
		$city_list = array();
		if(!empty($diplay_city_by_state)) {
        	$city_list = $obj->DisplayCitiesByState($diplay_city_by_state);
		}
?>
		<select name="city" class="form-control">
			<option value="">Select City</option>
			<?php
				if(!empty($city_list)) {
					foreach($city_list as $city) {
						if(!empty($city)) {
			?>
							<option value="<?php if(!empty($city)) { echo $obj->encode_decode('encrypt', $city); } ?>">
								<?php if(!empty($city)) { echo $city; } ?>
							</option>
			<?php     
						}       
					}
				}
			?>
		</select>
		<label>City (*)</label>
		<script type="text/javascript">
			jQuery(document).ready(function(){
				jQuery('form[name="customer_form"]').find('select').select2({ dropdownParent: jQuery('#AddCustomermodal') });
			});    
		</script>
<?php		
	}

    if(isset($_POST['name'])) {	
		$name = ""; $name_error = ""; $mobile_number = ""; $mobile_number_error = ""; $address = ""; $address_error = ""; $email = "";
		$email_error = ""; $city = ""; $city_error = ""; $state = ""; $state_error = "";

		$valid_customer = ""; $form_name = "customer_form";
	
        $name = $_POST['name'];
		$name = $valid->clean_value($name);
        $name_error = $valid->common_validation($name, "name", "text");
		if(!empty($name_error)) {
			$valid_customer = $valid->error_display($form_name, "name", $name_error, 'text');			
		}

		$mobile_number = $_POST['mobile_number'];
		$mobile_number_error = $valid->valid_mobile_number($mobile_number, "Mobile number", "1");
		if(!empty($mobile_number_error)) {
			if(!empty($valid_customer)) {
				$valid_customer = $valid_customer." ".$valid->error_display($form_name, "mobile_number", $mobile_number_error, 'text');
			}
			else {
				$valid_customer = $valid->error_display($form_name, "mobile_number", $mobile_number_error, 'text');
			}
		}

		$email = $_POST['email'];
        $email = $valid->clean_value($email);
		if(!empty($email)) {
			$email_error = $valid->valid_email($email, "Email", "1");
			if(!empty($email_error)) {
				if(!empty($valid_customer)) {
					$valid_customer = $valid_customer." ".$valid->error_display($form_name, "email", $email_error, 'text');
				}
				else {
					$valid_customer = $valid->error_display($form_name, "email", $email_error, 'text');
				}
			}
		}
		
		$address = $_POST['address'];
        $address = $valid->clean_value($address);
		$address_error = $valid->common_validation($address, "address", "text");
		if(!empty($address_error)) {
			if(!empty($valid_customer)) {
				$valid_customer = $valid_customer." ".$valid->error_display($form_name, "address", $address_error, 'textarea');
			}
			else {
				$valid_customer = $valid->error_display($form_name, "address", $address_error, 'textarea');
			}
		}
		
		$city = $_POST['city'];
        $city = $valid->clean_value($city);
		if(empty($city)) {
			$city_error = "Select the city";
		}
		if(!empty($city_error)) {
			if(!empty($valid_customer)) {
				$valid_customer = $valid_customer." ".$valid->error_display($form_name, "city", $city_error, 'select');
			}
			else {
				$valid_customer = $valid->error_display($form_name, "city", $city_error, 'select');
			}
		}

		$state = $_POST['state'];
        $state = $valid->clean_value($state);
		if(empty($state)) {
			$state_error = "Select the state";
		}
		if(!empty($state_error)) {
			if(!empty($valid_customer)) {
				$valid_customer = $valid_customer." ".$valid->error_display($form_name, "state", $state_error, 'select');
			}
			else {
				$valid_customer = $valid->error_display($form_name, "state", $state_error, 'select');
			}
		}

		$customer_id = "";
		if(isset($_POST['customer_id'])) {
			$customer_id = $_POST['customer_id'];
		}
		
		$result = "";
		
		if(empty($valid_customer)) {
			$check_user_id_ip_address = "";
			$check_user_id_ip_address = $obj->check_user_id_ip_address();	
			if(preg_match("/^\d+$/", $check_user_id_ip_address)) {
				
				if(!empty($name)) {
					$name_array = "";
					$name_array = explode(" ", $name);
					if(is_array($name_array)) {
						for($n = 0; $n < count($name_array); $n++) {
							if(!empty($name_array[$n])) {
								$name_array[$n] = trim($name_array[$n]);
								$name_array[$n] = strtolower($name_array[$n]);
								$name_array[$n] = ucfirst($name_array[$n]);
							}
							else {
								unset($name_array[$n]);
							}
						}
						$name = implode(" ", $name_array);
					}    
					$name = $obj->encode_decode('encrypt', $name);
				}
				if(!empty($mobile_number)) {
					$mobile_number = $obj->encode_decode('encrypt', $mobile_number);
				}
				if(!empty($address)) {
					$address = $obj->encode_decode('encrypt', $address);
				}
				if(!empty($email)) {
					$email = $obj->encode_decode('encrypt', $email);
				}
				else {
					$email = $GLOBALS['null_value'];
				}
                
				$prev_customer_id = ""; $columns = array(); $values = array(); $check_customers = array(); $customer_error = "";			
				if(!empty($mobile_number)) {
					$check_customers = $obj->getTableRecords($GLOBALS['customer_table'], 'mobile_number', $mobile_number);
					if(!empty($check_customers)) {
						foreach($check_customers as $data) {
							if(!empty($data['mobile_number']) && $data['mobile_number'] == $mobile_number) {
								$prev_customer_id = $data['customer_id'];
							}
							if(!empty($prev_customer_id)) {
                                $customer_error = "This customer mobile number is already exist";
								break;
							}
						}
					}
                }
				

				if(empty($customer_id)) {
					if(empty($prev_customer_id)) {
						$created_date_time = $GLOBALS['create_date_time_label']; $creator = $GLOBALS['creator'];
						$creator_name = $obj->encode_decode('encrypt', $GLOBALS['user_name']);
						
						$action = "";
						if(!empty($name)) {
							$action = "New Customer Created. Name - ".$obj->encode_decode('decrypt', $name).", Mobile Number - ".$obj->encode_decode('decrypt', $mobile_number);
						}

						$null_value = $GLOBALS['null_value'];
						$columns = array('created_date_time', 'creator', 'creator_name', 'customer_id', 'name', 'mobile_number', 'email', 'address', 'city', 'state', 'deleted');
						$values = array("'".$created_date_time."'", "'".$creator."'", "'".$creator_name."'", "'".$null_value."'", "'".$name."'", "'".$mobile_number."'", "'".$email."'", "'".$address."'", "'".$city."'", "'".$state."'", "'0'");
						$customer_insert_id = $obj->InsertSQL($GLOBALS['customer_table'], $columns, $values, $action);						
						if(preg_match("/^\d+$/", $customer_insert_id)) {
							$customer_id = "";
							if($customer_insert_id < 10) {
								$customer_id = "CUSTOMER_0".$customer_insert_id;
							}
							else {
								$customer_id = "CUSTOMER_".$customer_insert_id;
							}
							if(!empty($customer_id)) {
								$customer_id = $obj->encode_decode('encrypt', $customer_id);
							}
							$columns = array(); $values = array();						
							$columns = array('customer_id');
							$values = array("'".$customer_id."'");
							$customer_update_id = $obj->UpdateSQL($GLOBALS['customer_table'], $customer_insert_id, $columns, $values, '');
							if(preg_match("/^\d+$/", $customer_update_id)) {
								$result = array('number' => '1', 'msg' => 'Customer Successfully Created');					
							}
							else {
								$result = array('number' => '2', 'msg' => $customer_update_id);
							}
						}
						else {
							$result = array('number' => '2', 'msg' => $customer_insert_id);
						}
					}
					else {
						$result = array('number' => '2', 'msg' => $customer_error, 'load_customer_mobile_number' => $mobile_number);
					}
				}
				else {
					if(empty($prev_customer_id) || $prev_customer_id == $customer_id) {
						$getUniqueID = "";
						$getUniqueID = $obj->getTableColumnValue($GLOBALS['customer_table'], 'customer_id', $customer_id, 'id');
						if(preg_match("/^\d+$/", $getUniqueID)) {
							$action = "";
							if(!empty($name)) {
								$action = "Customer Updated. Name - ".$obj->encode_decode('decrypt', $name).", Mobile Number - ".$obj->encode_decode('decrypt', $mobile_number);
							}
						
							$columns = array(); $values = array();			
							$columns = array('name', 'mobile_number', 'email', 'address', 'city', 'state');
							$values = array("'".$name."'", "'".$mobile_number."'", "'".$email."'", "'".$address."'", "'".$city."'", "'".$state."'");
							$customer_update_id = $obj->UpdateSQL($GLOBALS['customer_table'], $getUniqueID, $columns, $values, $action);
							if(preg_match("/^\d+$/", $customer_update_id)) {			
								$result = array('number' => '1', 'msg' => 'Updated Successfully');						
							}
							else {
								$result = array('number' => '2', 'msg' => $customer_update_id);
							}							
						}
					}
					else {
						$result = array('number' => '2', 'msg' => $customer_error);
					}
                }
			}
			else {
				$result = array('number' => '2', 'msg' => 'Invalid IP');
			}
		}
		else {
			$result = array('number' => '3', 'msg' => $valid_customer);
		}
		
		if(!empty($result)) {
			$result = json_encode($result);
		}
		echo $result; exit;
	}

	if(isset($_REQUEST['display_mobile_number_customer'])) {
		$display_mobile_number_customer = $_REQUEST['display_mobile_number_customer'];
		if(!empty($display_mobile_number_customer)) {
			$customer_list = array();
			if(!empty($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id']) && isset($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id'])) {
				$customer_list = $obj->getTableRecords($GLOBALS['customer_table'], 'mobile_number', $display_mobile_number_customer);
?>
				<div class="input-group" style="position:initial;">
					<select name="customer_id" class="form-control" onChange="Javascript:getDeliveryAddress(this.value);">
						<option value="">Select Customer</option>
						<?php
							if(!empty($customer_list)) {
								foreach($customer_list as $data) {
									if(!empty($data['customer_id'])) {
						?>
										<option value="<?php if(!empty($data['customer_id'])) { echo $data['customer_id']; } ?>">
											<?php
												if(!empty($data['name'])) {
													$data['name'] = $obj->encode_decode('decrypt', $data['name']);
													echo $data['name'];
													if(!empty($data['city']) && $data['city'] != $GLOBALS['null_value']) {
														$data['city'] = $obj->encode_decode('decrypt', $data['city']);
														echo " - ".$data['city'];
													}
												}
											?>
										</option>
						<?php     
									}       
								}
							}
						?>
					</select>
					<div style="position: inherit; top: 0px;" class="input-group-append">
						<button class="btn btn-dark poppins" style="font-size:11px;" type="button" onClick="javascript:AddCustomer();"><i class="fa fa-user"></i></button>
					</div>
				</div>
				<script type="text/javascript">
					jQuery(document).ready(function(){
						jQuery('#customer_list').find('select').select2();
					});    
				</script>
<?php				
			}
		}
	}

	if(isset($_REQUEST['update_customer'])) {
		$update_customer = $_REQUEST['update_customer'];
		if(!empty($update_customer) && $update_customer == 1) {
			$customer_list = array();
			$staff_id = "";
			if(!empty($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id']) && isset($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id'])) {
				$staff_id = $obj->getTableColumnValue($GLOBALS['user_table'], 'user_id', $_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id'], 'staff_id');
				if(!empty($staff_id) && $staff_id != $GLOBALS['null_value']) {
					//$customer_list = $obj->StaffCreatedCustomers($staff_id, '0');
					$customer_list = $obj->getTableRecords($GLOBALS['customer_table'], 'creator', $staff_id);
				}
				else {
					$customer_list = $obj->getTableRecords($GLOBALS['customer_table'], '', '');
				}
			}
?>
			<div class="input-group" style="position:initial;">
				<select name="customer_id" class="form-control" onChange="Javascript:getDeliveryAddress(this.value);">
					<option value="">Select Customer</option>
					<?php
						if(!empty($customer_list)) {
							foreach($customer_list as $data) {
								if(!empty($data['customer_id'])) {
					?>
									<option value="<?php if(!empty($data['customer_id'])) { echo $data['customer_id']; } ?>">
										<?php
											if(!empty($data['name'])) {
												$data['name'] = $obj->encode_decode('decrypt', $data['name']);
												echo $data['name'];
												if(!empty($data['city']) && $data['city'] != $GLOBALS['null_value']) {
													$data['city'] = $obj->encode_decode('decrypt', $data['city']);
													echo " - ".$data['city'];
												}
											}
										?>
									</option>
					<?php     
								}       
							}
						}
					?>
				</select>
				<div style="position: inherit; top: 0px;" class="input-group-append">
					<button class="btn btn-dark poppins" style="font-size:11px;" type="button" onClick="javascript:AddCustomer();"><i class="fa fa-user"></i></button>
				</div>
			</div>
			<script type="text/javascript">
				jQuery(document).ready(function(){
					jQuery('#customer_list').find('select').select2();
				});    
			</script>
<?php			
		}
	}

	if(isset($_REQUEST['delivery_address_customer_id'])) {
		$delivery_address_customer_id = $_REQUEST['delivery_address_customer_id'];
		if(!empty($delivery_address_customer_id)) {
			$customer_list = array(); $delivery_address = "";
			$customer_list = $obj->getTableRecords($GLOBALS['customer_table'], 'customer_id', $delivery_address_customer_id);
			if(!empty($customer_list)) {
				foreach($customer_list as $data) {
					if(!empty($data['address'])) {
						$delivery_address = $obj->encode_decode('decrypt', $data['address']);
						$delivery_address = str_replace("<br>", "\r\n", $delivery_address);
					}
					if(!empty($data['city']) && $data['city'] != $GLOBALS['null_value']) {
						$data['city'] = $obj->encode_decode('decrypt', $data['city']);
						$delivery_address = $delivery_address."\r\n".$data['city'];
					}
					if(!empty($data['state'])) {
						$data['state'] = $obj->encode_decode('decrypt', $data['state']);
						$delivery_address = $delivery_address."\r\n".$data['state'];
					}
				}
			}
			echo $delivery_address;
			exit;
		}
	}

	if(isset($_REQUEST['price_content_product_id'])) {
		$price_content_product_id = $_REQUEST['price_content_product_id'];
		$price_content_product_id = trim($price_content_product_id);

		$order_type = $_REQUEST['order_type'];
		$order_type = trim($order_type);
		$check_order_type = "";
		if(!empty($order_type)) {
			$check_order_type = $obj->encode_decode('decrypt', $order_type);
		}

		if(!empty($price_content_product_id)) {
			$product_content = "";
			$product_content = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_id', $price_content_product_id, 'product_content');
			if(!empty($product_content)) {
				$product_content = $obj->encode_decode('decrypt', $product_content);
			}

			$price = "";
			$price = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_id', $price_content_product_id, 'price');

			$category_id = ""; $category_discount = 0;
			$category_id = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_id', $price_content_product_id, 'category_id');
			if(!empty($category_id)) {
				$category_discount = $obj->getCategoryDiscount($category_id);
				$category_discount = trim($category_discount);
			}

			$product_price_display_format = 1;
			$product_price_display_format = $obj->getTableColumnValue($GLOBALS['settings_table'], 'name', 'product_price_display_format', 'value');
			$actual_price = 0; $discounted_price = 0;
			//echo "price - ".$price.", category_discount - ".$category_discount.", product_price_display_format - ".$product_price_display_format;
			if(!empty($product_price_display_format)) {
				if($product_price_display_format == 1) {
					if(!empty($price)) {
						$actual_price = $price;
						if(!empty($category_discount)) {
							$discounted_value = 0;
							$discounted_value = ($actual_price * $category_discount) / 100;
							if(!empty($discounted_value)) {
								$discounted_value = number_format($discounted_value, 2);
								$discounted_value = str_replace(",", "", $discounted_value);
								$discounted_price = $actual_price - $discounted_value;
							}
						}
						else {
							$discounted_price = $actual_price;
						}
					}
				}
				else if($product_price_display_format == 2) {
					if(!empty($price)) {
						$discounted_price = $price;
						if(!empty($discounted_price)) {
							if(!empty($category_discount) && !empty($discounted_price)) {
								$actual_price = $obj->getActualPrice($discounted_price, $category_discount);
							}
							else {
								$actual_price = $discounted_price;   
							}
						}
					}
				}
				$price = $discounted_price;
			}

			if(!empty($price)) {
				$price = number_format($price, 2);
				$price = str_replace(",", "", $price);
			}

			$result = "";
			$result = array('product_content' => $product_content, 'price' => $price);
			if(!empty($result)) {
				$result = json_encode($result);
			}
			echo $result; exit;
		}
	}

	if(isset($_REQUEST['get_discount_product_id'])) {
		$get_discount_product_id = $_REQUEST['get_discount_product_id'];
		$get_discount_product_id = trim($get_discount_product_id);

		$order_type = $_REQUEST['order_type'];
		$order_type = trim($order_type);
		$check_order_type = "";
		if(!empty($order_type)) {
			$check_order_type = $obj->encode_decode('decrypt', $order_type);
		}

		$discount = 0;
		if(!empty($get_discount_product_id)) {
			$category_id = "";
			$category_id = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_id', $get_discount_product_id, 'category_id');
			if(!empty($category_id)) {
				$discount = $obj->getCategoryDiscount($category_id);
				$discount = trim($discount);

				$apply_frontend_actual_rate = "";
				$apply_frontend_actual_rate = $obj->getTableColumnValue($GLOBALS['settings_table'], 'name', 'apply_frontend_actual_rate', 'value');
				if(!empty($apply_frontend_actual_rate)) {
					if($check_order_type == $GLOBALS['frontend_order']) {
						$apply_frontend_actual_rate = 1;
					}
					if($apply_frontend_actual_rate == 2) {
						if(!empty($discount)) { $discount = 0; }
					}
				}
			}
		}
		echo $discount;
		exit;
	}

	if(isset($_REQUEST['add_product'])) {
        $selected_product_id = $_REQUEST['selected_product_id'];
		$selected_product_id = trim($selected_product_id);

        $selected_quantity = $_REQUEST['selected_quantity'];
		$selected_quantity = trim($selected_quantity);

        $selected_rate = $_REQUEST['selected_rate'];
		$selected_rate = trim($selected_rate);

		$order_type = $_REQUEST['order_type'];
		$order_type = trim($order_type);

		$check_order_type = "";
		if(!empty($order_type)) {
			$check_order_type = $obj->encode_decode('decrypt', $order_type);
		}

		if(!empty($selected_rate)) {
			$selected_rate = number_format($selected_rate, 2);
			$selected_rate = str_replace(",", "", $selected_rate);
		}

        $amount = 0;
        if(!empty($selected_quantity) && !empty($selected_rate)) {
            $amount = $selected_quantity * $selected_rate;
            if(!empty($amount)) {
                $amount = number_format($amount, 2);
				$amount = str_replace(",", "", $amount);
            }
        }
		
		$category_id = ""; $discount = 0;
		$category_id = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_id', $selected_product_id, 'category_id');
		if(!empty($category_id)) {
			$discount = $obj->getCategoryDiscount($category_id);
			$discount = trim($discount);
		}

		$apply_frontend_actual_rate = "";
		$apply_frontend_actual_rate = $obj->getTableColumnValue($GLOBALS['settings_table'], 'name', 'apply_frontend_actual_rate', 'value');
		if(!empty($apply_frontend_actual_rate)) {
			if($check_order_type == $GLOBALS['frontend_order']) {
				$apply_frontend_actual_rate = 1;
			}
		}
		if(!empty($apply_frontend_actual_rate) && $apply_frontend_actual_rate == 2) {
			if(!empty($discount)) { $discount = 0; }
		}

		$actual_price = 0;
		if(!empty($discount) && !empty($selected_rate)) {
			$actual_price = $obj->getActualPrice($selected_rate, $discount);
		}
		else {
			$actual_price = $selected_rate;
		}
?>
        <tr class="product_row <?php echo $discount; ?>_discount_product_row">  
			<td class="text-center" style="padding: 5px; vertical-align: middle;">
				<div class="sno w-100 mb-1"></div>
				<?php if($check_order_type != $GLOBALS['frontend_order']) { ?>
				<input type="checkbox" name="product_checkbox" value="<?php if(!empty($selected_product_id)) { echo $selected_product_id;} ?>">
				<?php } ?>
			</td>
            <td style="padding: 5px; vertical-align: middle;">
                <?php
                    if(!empty($selected_product_id)) {
						$product_name = "";
						$product_name = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_id', $selected_product_id, 'name');
						if(!empty($product_name)) {
							$product_name = $obj->encode_decode('decrypt', $product_name);
							$product_name = str_replace("$", '"', $product_name);
							echo $product_name;
						}

                ?>
                        <input type="hidden" name="product_id[]" value="<?php if(!empty($selected_product_id)) { echo $selected_product_id; } ?>">
						<input type="hidden" name="product_discount[]" value="<?php if(!empty($discount)) { echo $discount; } else { echo "0"; } ?>">	
                <?php        
                    }
                ?>
            </td>

			<td style="padding: 5px; vertical-align: middle;">
				<input type="text" name="actual_price[]" style="padding: 5px !important;" class="form-control w-100" onkeyup="Javascript:ProductRowCheck(this);" value="<?php if(!empty($actual_price)) { echo $actual_price; } ?>">
			</td>
			<td style="padding: 5px; vertical-align: middle;">
				<input type="hidden" name="rate[]" style="padding: 5px !important;" class="form-control w-100" value="<?php if(!empty($selected_rate)) { echo $selected_rate; } ?>">
				<span class="rate"><?php if(!empty($selected_rate)) { echo $selected_rate; } ?></span>
			</td>
			<td style="padding: 5px; vertical-align: middle;">
                <input type="text" name="quantity[]" class="form-control w-100" style="padding: 5px !important;" onkeyup="Javascript:ProductRowCheck(this);" value="<?php if(!empty($selected_quantity)) { echo $selected_quantity; } ?>">
            </td>
            <td class="amount text-right" style="padding: 5px; vertical-align: middle;"><?php if(!empty($amount)) { echo $amount; } ?></td>
            <td class="text-center" style="padding: 5px; vertical-align: middle;">
                <button type="button" onClick="Javascript:DeleteProductRow(this);" class="btn"> <i class="fa fa-trash"></i></button>
            </td>    
        </tr>    
<?php        
    }

	if(isset($_REQUEST['custom_product_row_index'])) {
		$custom_product_row_index = $_REQUEST['custom_product_row_index']; {
			if(!empty($custom_product_row_index) && $custom_product_row_index == 1) {
				$custom_product_id = $obj->encode_decode('encrypt', "Custom Product - ".date("dmYhis"));
?>
				<tr class="product_row custom_product_row 0_discount_product_row">  
					<td class="text-center" style="padding: 5px; vertical-align: middle;">
						<div class="sno w-100 mb-1"></div>
						<input type="checkbox" name="product_checkbox" value="<?php if(!empty($custom_product_id)) { echo $custom_product_id;} ?>">
					</td> 
					<td style="padding: 5px; vertical-align: middle;">
						<input type="text" name="custom_product_<?php if(!empty($custom_product_id)) { echo $custom_product_id; } ?>" class="form-control" value="">
						<input type="hidden" name="product_id[]" value="<?php if(!empty($custom_product_id)) { echo $custom_product_id; } ?>">
						<input type="hidden" name="product_discount[]" value="0">
					</td>
					<td style="padding: 5px; vertical-align: middle;">
						<input type="text" name="actual_price[]" style="padding: 5px !important;" class="form-control w-100" onkeyup="Javascript:ProductRowCheck(this);" value="">
					</td>
					<td style="padding: 5px; vertical-align: middle;">
						<input type="hidden" name="rate[]" style="padding: 5px !important;" class="form-control w-100" value="">
						<span class="rate"></span>
					</td>
					<td style="padding: 5px; vertical-align: middle;">
						<input type="text" name="quantity[]" style="padding: 5px !important;" class="form-control w-100" onkeyup="Javascript:ProductRowCheck(this);" value="">
					</td>
					<td class="amount text-right" style="padding: 5px; vertical-align: middle;"></td>
					<td class="text-center" style="padding: 5px; vertical-align: middle;">
						<button type="button" onClick="Javascript:DeleteProductRow(this);" class="btn"> <i class="fa fa-trash"></i></button>
					</td>    
				</tr>
<?php				
			}
		}
	}

	if(isset($_POST['customer_id'])) {
		$order_number = ""; $order_date = ""; $customer_id = ""; $customer_id_error = ""; $delivery_address = ""; $delivery_address_error = "";
		$product_ids = array(); $category_ids = array(); $category_names = array(); $product_names = array(); $product_codes = array();
		$product_contents = array(); $quantity_values = array(); $rate_values = array(); $actual_rate_values = array(); $discount_values = array();
		$direct_order_error = ""; $order_type = ""; $extra_discount = ""; $extra_discount_extension = ""; $show_extra_discount_amount = 2;
		$minimum_order_amount = $GLOBALS['null_value']; $packing_charges = $GLOBALS['null_value'];

		$valid_direct_order = ""; $form_name = "direct_order_form";

		$edit_order_id = "";
		if(isset($_POST['edit_order_id'])) {
			$edit_order_id = $_POST['edit_order_id'];
		}

		if(!empty($edit_order_id)) {
			$order_number = $obj->getTableColumnValue($GLOBALS['order_table'], 'order_id', $edit_order_id, 'order_number');
		}
		else {
			$order_number = $obj->automate_number($GLOBALS['order_table'], 'order_number');
			if(!empty($order_number)) {
				$order_number = $obj->encode_decode('encrypt', $order_number);
			}
		}

		$order_date = $_POST['order_date'];
		$order_date = $valid->clean_value($order_date);
		if(empty($order_date)) {
			if(!empty($direct_order_error)) {
				$direct_order_error = $direct_order_error."<br>Order date is missing";
			}
			else {
				$direct_order_error = "Order date is missing";
			}
		}

		$order_type = $_POST['order_type'];
		$order_type = $valid->clean_value($order_type);
		if(empty($order_type)) {
			if(!empty($direct_order_error)) {
				$direct_order_error = $direct_order_error."<br>Order type is missing";
			}
			else {
				$direct_order_error = "Order type is missing";
			}
		}

		$customer_id = $_POST['customer_id'];
		$customer_id = $valid->clean_value($customer_id);
        if(empty($customer_id)) {
            $customer_id_error = "Select the customer";
        }
		if(!empty($customer_id_error)) {
			$valid_direct_order = $valid->error_display($form_name, "customer_id", $customer_id_error, 'select');			
		}

		$delivery_address = $_POST['delivery_address'];
        $delivery_address = $valid->clean_value($delivery_address);
		if(empty($delivery_address)) {
			$delivery_address_error = "Enter the delivery address";
		}
		if(!empty($delivery_address_error)) {
			if(!empty($valid_direct_order)) {
				$valid_direct_order = $valid_direct_order." ".$valid->error_display($form_name, "delivery_address", $delivery_address_error, 'textarea');
			}
			else {
				$valid_direct_order = $valid->error_display($form_name, "delivery_address", $delivery_address_error, 'textarea');
			}
		}

		if(isset($_POST['product_id'])) {
            $product_ids = $_POST['product_id'];
        }
        if(isset($_POST['quantity'])) {
            $quantity_values = $_POST['quantity'];
        }
        if(isset($_POST['rate'])) {
            $rate_values = $_POST['rate'];
        }
		if(isset($_POST['actual_price'])) {
            $actual_rate_values = $_POST['actual_price'];
        }
		if(isset($_POST['product_discount'])) {
            $discount_values = $_POST['product_discount'];
        }

		$show_extra_discount_amount = 1;
		if(isset($_POST['extra_discount'])) {
			$extra_discount = $_POST['extra_discount'];
			if(!empty($extra_discount)) {
				$check_extra_discount = $extra_discount;
				if (strpos($check_extra_discount, '%') !== false) {
					$check_extra_discount = str_replace("%", "", $check_extra_discount);
				}
				$extra_discount_error = "";
				$extra_discount_error = $valid->valid_price($check_extra_discount, 'Packing Charges', '1');
				if(!empty($extra_discount_error)) {
					if(!empty($valid_direct_order)) {
						$valid_direct_order = $valid_direct_order." ".$valid->error_display($form_name, "extra_discount", $extra_discount_error, 'text');
					}
					else {
						$valid_direct_order = $valid->error_display($form_name, "extra_discount", $extra_discount_error, 'text');
					}
				}
			}
		}

		if(isset($_POST['packing_charges'])) {
			$packing_charges = $_POST['packing_charges'];
			if(!empty($packing_charges)) {
				$check_packing_charges = $packing_charges;
				if (strpos($check_packing_charges, '%') !== false) {
					$check_packing_charges = str_replace("%", "", $check_packing_charges);
				}
				$packing_charges_error = "";
				$packing_charges_error = $valid->valid_price($check_packing_charges, 'Packing Charges', '1');
				if(!empty($packing_charges_error)) {
					if(!empty($valid_direct_order)) {
						$valid_direct_order = $valid_direct_order." ".$valid->error_display($form_name, "packing_charges", $packing_charges_error, 'text');
					}
					else {
						$valid_direct_order = $valid->error_display($form_name, "packing_charges", $packing_charges_error, 'text');
					}
				}
			}
		}

        $products_error = ""; $show_products = 0; $product_listing = 0; $submit_product_ids = array(); 
		
		$total_amount = 0;

		if(!empty($product_ids) && !empty($quantity_values) && !empty($rate_values)) {
			for($n = 0; $n < count($product_ids); $n++) {
                $product_ids[$n] = trim($product_ids[$n]);
				if(!empty($product_ids[$n])) {
					
					$duplicate_entry = 0;
					for($s = 0; $s < count($submit_product_ids); $s++) {
						if( $product_ids[$n] == $submit_product_ids[$s] ) {
							$duplicate_entry++;
						}
					}
                    if(empty($duplicate_entry)) { 
                        $submit_product_ids[] = $product_ids[$n]; 
                    }
					if($duplicate_entry > 1) { $products_error = "Remove repeated products"; }

					$show_products = 1;	

                    $quantity_values[$n] = trim($quantity_values[$n]);
                    $rate_values[$n] = str_replace(",", "", $rate_values[$n]);
                    $rate_values[$n] = trim($rate_values[$n]);

					if(!empty($quantity_values[$n])) {                
						if(preg_match('/^[0-9]*$/', $quantity_values[$n])) {							
							if(!empty($rate_values[$n])) {                
								if(preg_match('/^[0-9]+(\\.[0-9]+)?$/', $rate_values[$n])) {

									$price = "";
									if(!empty($actual_rate_values[$n]) && preg_match('/^[0-9]+(\\.[0-9]+)?$/', $actual_rate_values[$n])) {
										$discount_values[$n] = trim($discount_values[$n]);
										if(!empty($discount_values[$n]) && preg_match('/^[0-9]+(\\.[0-9]+)?$/', $discount_values[$n])) {
											$discounted_value = 0;
											$discounted_value = ($actual_rate_values[$n] * $discount_values[$n]) / 100;
											if(!empty($discounted_value)) {
												$discounted_value = number_format($discounted_value, 2);
												$discounted_value = str_replace(",", "", $discounted_value);
												$price = $actual_rate_values[$n] - $discounted_value;
											}       
										}
										else {
											$price = $actual_rate_values[$n];
										}
									}

									//echo "price - ".$price."<br>";
									
									$amount = 0;
									$amount = $quantity_values[$n] * $price;
									if(!empty($amount)) {
										$amount = number_format($amount, 2);
										$amount = trim(str_replace(",", "", $amount));
										$total_amount = $total_amount + $amount;
									}

									$product_list = array(); $category_id = "";
									$product_list = $obj->getTableRecords($GLOBALS['product_table'], 'product_id', $product_ids[$n]);
									if(!empty($product_list)) {
										foreach($product_list as $data) {
											if(!empty($data['category_id'])) {
												$category_id = $data['category_id'];
											}
											if(!empty($data['name'])) {
												$product_names[$n] = $data['name'];
											}
											if(!empty($data['product_code'])) {
												$product_codes[$n] = $data['product_code'];
											}
											if(!empty($data['product_content'])) {
												$product_contents[$n] = $data['product_content'];
											}
										}
										if(!empty($category_id)) {
											$category_ids[$n] = $category_id;
											$category_name = "";
											$category_name = $obj->getTableColumnValue($GLOBALS['category_table'], 'category_id', $category_id, 'name');
											if(!empty($category_name)) {
												$category_names[$n] = $category_name;
											}
										}
									}
									else {
										$custom_product_name = ""; $custom_product_discount = 0; $custom_product = "custom_product_".$product_ids[$n];
										if(isset($_POST[$custom_product])) {
											$custom_product_name = $_POST[$custom_product];
											$custom_product_name = $valid->clean_value($custom_product_name);
											if(!empty($custom_product_name)) {
												$custom_product_name = str_replace('"', "$", $custom_product_name);
												$custom_product_name = $obj->encode_decode('encrypt', $custom_product_name);
												$product_names[$n] = $custom_product_name;
												$product_codes[$n] = $GLOBALS['null_value'];
												$product_contents[$n] = $GLOBALS['null_value'];
												$category_ids[$n] = $GLOBALS['null_value'];
												$category_names[$n] = $GLOBALS['null_value'];
											}
											else {
												$products_error = "Empty Custom Product";
											}
										}
									}

								}
								else {
									$products_error = "Invalid rate";
								}
							}
							else {
								$products_error = "Empty rate";
							}
						}
						else {
							$products_error = "Invalid quantity";
						}
					}
					else {
						$products_error = "Empty quantity";
					}
				}
				else { $products_error = "Empty Products"; }
				if(!empty($products_error)) { break; }
			}
			if(!empty($show_products) && empty($products_error)) {
				$product_listing = 1;
			}
		}

        if(empty($product_listing) && empty($products_error)) {
			$products_error = "Please select the products";
		}

		if(!empty($products_error)) {
			if(!empty($direct_order_error)) {
				$direct_order_error = $direct_order_error."<br>".$products_error;
			}
			else {
				$direct_order_error = $products_error;
			}
		}

		//echo "total_amount 1 - ".$total_amount."<br>";

		$promotion_code_price = ""; $promotion_code_discount_value = "";
		if(!empty($edit_order_id)) {
			$view_orders = array();
			$view_orders = $obj->getTableRecords($GLOBALS['order_table'], 'order_id', $edit_order_id);
			if(!empty($view_orders)) {
				foreach($view_orders as $data) {
					if(!empty($data['promotion_code_price']) && $data['promotion_code_price'] != $GLOBALS['null_value']) {
						$promotion_code_price = $data['promotion_code_price'];
					}
					if(!empty($data['promotion_code_discount_value']) && $data['promotion_code_discount_value'] != $GLOBALS['null_value']) {
						$promotion_code_discount_value = $data['promotion_code_discount_value'];
					}
				}
			}
		}
		if(!empty($promotion_code_discount_value)) {
			$total_amount = $total_amount - $promotion_code_discount_value;
			if(!empty($total_amount)) {
				$total_amount = number_format($total_amount, 2);
				$total_amount = trim(str_replace(",", "", $total_amount));
			}
		}

		//echo "total_amount 2 - ".$total_amount."<br>";

		if(!empty($packing_charges)) {
			$packing_charges_value = 0;
			if (strpos($packing_charges, '%') !== false) {
				$packing_charges = trim(str_replace("%", "", $packing_charges));
				$packing_charges_value = ($total_amount * $packing_charges) / 100;
				if(!empty($packing_charges_value)) {
					$packing_charges_value = number_format($packing_charges_value, 2);
					$packing_charges_value = trim(str_replace(",", "", $packing_charges_value));
					$packing_charges = $packing_charges."%";
				}
			}
			else {
				$packing_charges_value = $packing_charges;
			}
			if(!empty($packing_charges_value)) {
				$total_amount = $total_amount + $packing_charges_value;
				if(!empty($total_amount)) {
					$total_amount = number_format($total_amount, 2);
					$total_amount = trim(str_replace(",", "", $total_amount));
				}
			}
		}
		else {
			if(empty($packing_charges)) {
				$packing_charges = $GLOBALS['null_value'];
			}
		}

		//echo "total_amount 3 - ".$total_amount."<br>";

		if(!empty($extra_discount)) {
			$extra_discount_value = 0;
			if (strpos($extra_discount, '%') !== false) {
				$extra_discount = trim(str_replace("%", "", $extra_discount));
				$extra_discount_value = ($total_amount * $extra_discount) / 100;
				if(!empty($extra_discount_value)) {
					$extra_discount_value = number_format($extra_discount_value, 2);
					$extra_discount_value = trim(str_replace(",", "", $extra_discount_value));
					$extra_discount = $extra_discount."%";
				}
			}
			else {
				$extra_discount_value = $extra_discount;
			}
			if(!empty($extra_discount_value)) {
				$total_amount = $total_amount - $extra_discount_value;
				if(!empty($total_amount)) {
					$total_amount = number_format($total_amount, 2);
					$total_amount = trim(str_replace(",", "", $total_amount));
				}
			}
		}
		else {
			if(empty($extra_discount)) {
				$extra_discount = $GLOBALS['null_value'];
			}
		}

		//echo "total_amount 4 - ".$total_amount."<br>";

		if(!empty($total_amount)) {
			if (strpos( $total_amount, "." ) !== false) {
				$pos = strpos($total_amount, ".");
				$decimal = substr($total_amount, ($pos + 1), strlen($total_amount));
				if($decimal != "00") {
					if(strlen($decimal) == 1) {
						$decimal = $decimal."0";
					}
					if($decimal >= 50) {
						$round_off = 100 - $decimal;
						$round_off = trim($round_off);
						if(strlen($round_off) == 1) {
							$round_off = '0.0'.$round_off;
						}
						else {
							$round_off = '0.'.$round_off;
						}
						$total_amount = $total_amount + $round_off;
					}
					else {
						$round_off = $decimal;
						$round_off = trim($round_off);
						if(strlen($round_off) == 1) {
							$round_off = '0.0'.$round_off;
						}
						else {
							$round_off = '0.'.$round_off;
						}
						$total_amount = $total_amount - $round_off;
					}
				}
			}
		}

		//echo "total_amount - ".$total_amount; exit;

		$result = "";
		
		if(empty($valid_direct_order) && empty($direct_order_error)) { 

			$check_user_id_ip_address = "";
			$check_user_id_ip_address = $obj->check_user_id_ip_address();	
			if(preg_match("/^\d+$/", $check_user_id_ip_address)) {
				if(!empty($order_date)) {
					$order_date = date("Y-m-d", strtotime($order_date));
				}
				if(!empty($delivery_address)) {
					$delivery_address = $obj->encode_decode('encrypt', $delivery_address);
				}

				$customer_details = ""; $customer_city = "";
				if(!empty($customer_id)) {
					$customer_name = "";
					$customer_name = $obj->getTableColumnValue($GLOBALS['customer_table'], 'customer_id', $customer_id, 'name');
					if(!empty($customer_name)) {
						$customer_name = $obj->encode_decode('decrypt', $customer_name);
						$customer_details = $customer_name;
					}
					$customer_city = $obj->getTableColumnValue($GLOBALS['customer_table'], 'customer_id', $customer_id, 'city');
					$customer_mobile_number = "";
					$customer_mobile_number = $obj->getTableColumnValue($GLOBALS['customer_table'], 'customer_id', $customer_id, 'mobile_number');
					if(!empty($customer_mobile_number)) {
						$customer_mobile_number = $obj->encode_decode('decrypt', $customer_mobile_number);
						$customer_details = $customer_details."<br>".$customer_mobile_number;
					}
					$customer_email = "";
					$customer_email = $obj->getTableColumnValue($GLOBALS['customer_table'], 'customer_id', $customer_id, 'email');
					if(!empty($customer_email) && $customer_email != $GLOBALS['null_value']) {
						$customer_email = $obj->encode_decode('decrypt', $customer_email);
						$customer_details = $customer_details."<br>".$customer_email;
					}
					if(!empty($customer_details)) {
						$customer_details = $obj->encode_decode('encrypt', $customer_details);
					}
				}

				$company_details = ""; $bank_details = "";
				$company_name = ""; $company_address = ""; $company_mobile_number = ""; $company_email = "";
				$ac_name = ""; $ac_number= ""; $ac_type = ""; $bank_name = ""; $ifsc_code = "";
				$company_list = array();
				$company_list = $obj->getTableRecords($GLOBALS['company_table'], '', '');
				if(!empty($company_list)) {
					foreach($company_list as $data) {
						if(!empty($data['name'])) {
							$company_details = $obj->encode_decode('decrypt', $data['name']);
						}
						if(!empty($data['address']) && $data['address'] != $GLOBALS['null_value']) {
							$company_address = $obj->encode_decode('decrypt', $data['address']);
							$company_address = str_replace("\r\n", " ", $company_address);
							$company_details = $company_details."<br>".$company_address;
						}
						if(!empty($data['mobile_number']) && $data['mobile_number'] != $GLOBALS['null_value']) {
							$company_mobile_number = $obj->encode_decode('decrypt', $data['mobile_number']);
							$company_details = $company_details."<br>".$company_mobile_number;
						}
						else {
							$company_details = $company_details."<br> ";
						}
						if(!empty($data['email']) && $data['address'] != $GLOBALS['null_value']) {
							$company_email = $obj->encode_decode('decrypt', $data['email']);
							$company_details = $company_details."<br>".$company_email;
						}
						else {
							$company_details = $company_details."<br> ";
						}
						if( (!empty($data['ac_name']) && $data['ac_name'] != $GLOBALS['null_value']) || (!empty($data['ac_number']) && $data['ac_number'] != $GLOBALS['null_value']) || (!empty($data['ac_type']) && $data['ac_type'] != $GLOBALS['null_value']) || (!empty($data['bank_name']) && $data['bank_name'] != $GLOBALS['null_value']) || (!empty($data['ifsc_code']) && $data['ifsc_code'] != $GLOBALS['null_value'])) {
							if(!empty($data['ac_name']) && $data['ac_name'] != $GLOBALS['null_value']) {
								$bank_details = $obj->encode_decode('decrypt', $data['ac_name']);
							}
							if(!empty($data['ac_number']) && $data['ac_number'] != $GLOBALS['null_value']) {
								$ac_number = $obj->encode_decode('decrypt', $data['ac_number']);
								$bank_details = $bank_details."<br>".$ac_number;
							}
							if(!empty($data['ac_type']) && $data['ac_type'] != $GLOBALS['null_value']) {
								$ac_type = $obj->encode_decode('decrypt', $data['ac_type']);
								$bank_details = $bank_details."<br>".$ac_type;
							}
							if(!empty($data['bank_name']) && $data['bank_name'] != $GLOBALS['null_value']) {
								$bank_name = $obj->encode_decode('decrypt', $data['bank_name']);
								$bank_details = $bank_details."<br>".$bank_name;
							}
							if(!empty($data['ifsc_code']) && $data['ifsc_code'] != $GLOBALS['null_value']) {
								$ifsc_code = $obj->encode_decode('decrypt', $data['ifsc_code']);
								$bank_details = $bank_details."<br>".$ifsc_code;
							}
						}
					}
					if(!empty($company_details)) {
						$company_details = $obj->encode_decode('encrypt', $company_details);
					}
					if(!empty($bank_details)) {
						$bank_details = $obj->encode_decode('encrypt', $bank_details);
					}
				}
				
				if(!empty($product_ids)) {
                    $product_ids = implode(",", $product_ids);
                }
				if(!empty($product_names)) {
                    $product_names = implode(",", $product_names);
                }
				if(!empty($product_codes)) {
                    $product_codes = implode(",", $product_codes);
                }
				if(!empty($product_contents)) {
                    $product_contents = implode(",", $product_contents);
                }
				if(!empty($category_ids)) {
                    $category_ids = implode(",", $category_ids);
                }
				if(!empty($category_names)) {
                    $category_names = implode(",", $category_names);
                }

                if(!empty($quantity_values)) {
                    $quantity_values = implode(",", $quantity_values);
                }
                if(!empty($actual_rate_values)) {
                    $actual_rate_values = implode(",", $actual_rate_values);
                }
				if(!empty($rate_values)) {
                    $rate_values = implode(",", $rate_values);
                }
				if(!empty($discount_values)) {
					$discount_values = implode(",", $discount_values);
				}
				
                
				$prev_order_id = ""; $order_error = "";			
				if(!empty($order_number)) {
					$prev_order_id = $obj->getTableColumnValue($GLOBALS['order_table'], 'order_number', $order_number, 'order_id');
					if(!empty($prev_order_id)) {
						$order_error = "This order number is already exist";
					}
                }

				$success = 0;

				if(empty($edit_order_id)) {
					if(empty($prev_order_id)) {
						$created_date_time = $GLOBALS['create_date_time_label']; $creator = $GLOBALS['creator'];
						$creator_name = $obj->encode_decode('encrypt', $GLOBALS['user_name']);
						
						$action = "";
						if(!empty($order_number)) {
							$action = "New Order Created. Order Number - ".$obj->encode_decode('decrypt', $order_number);
						}

						$null_value = $GLOBALS['null_value']; $order_insert_id = ""; $order_update_id = "";

						$new_order = 0; $confirmed = 0; $despatched = 0; $delivered = 0; $push_notification = 0; $delivery_number = $null_value;
						$delivery_particulars = $null_value; $delivery_photo = $null_value; $send_sms_email = 0;

						$columns = array('created_date_time', 'creator', 'creator_name', 'order_id', 'order_type', 'order_number', 'order_date', 'company_details', 'bank_details', 'customer_id', 'customer_details', 'customer_city', 'delivery_address', 'category_id', 'category_name', 'product_id', 'product_code', 'product_name', 'product_content', 'quantity', 'actual_price', 'price', 'discount', 'extra_discount', 'show_extra_discount_amount', 'minimum_order_amount', 'packing_charges', 'promotion_code_id', 'promotion_code_name', 'promotion_code_price', 'promotion_code_discount_value', 'otp_number', 'total_amount', 'new_order', 'confirmed', 'despatched', 'delivered', 'push_notification', 'delivery_number', 'delivery_particulars', 'delivery_photo', 'send_sms_email', 'deleted');
						$values = array("'".$created_date_time."'", "'".$creator."'", "'".$creator_name."'", "'".$null_value."'", "'".$order_type."'", "'".$order_number."'", "'".$order_date."'", "'".$company_details."'", "'".$bank_details."'", "'".$customer_id."'", "'".$customer_details."'", "'".$customer_city."'", "'".$delivery_address."'", "'".$category_ids."'", "'".$category_names."'", "'".$product_ids."'", "'".$product_codes."'", "'".$product_names."'", "'".$product_contents."'", "'".$quantity_values."'", "'".$actual_rate_values."'", "'".$rate_values."'", "'".$discount_values."'", "'".$extra_discount."'", "'".$show_extra_discount_amount."'", "'".$minimum_order_amount."'", "'".$packing_charges."'", "'".$null_value."'", "'".$null_value."'", "'".$null_value."'", "'".$null_value."'", "'".$null_value."'", "'".$total_amount."'", "'".$new_order."'", "'".$confirmed."'", "'".$despatched."'", "'".$delivered."'", "'".$push_notification."'", "'".$delivery_number."'", "'".$delivery_particulars."'", "'".$delivery_photo."'", "'".$send_sms_email."'", "'0'");
						$order_insert_id = $obj->InsertSQL($GLOBALS['order_table'], $columns, $values, $action);						
						if(preg_match("/^\d+$/", $order_insert_id)) {
							$order_id = "";
							if($order_insert_id < 10) {
								$order_id = "ORDER_0".$order_insert_id;
							}
							else {
								$order_id = "ORDER_".$order_insert_id;
							}
							if(!empty($order_id)) {
								$order_id = $obj->encode_decode('encrypt', $order_id);
							}
							$columns = array(); $values = array();						
							$columns = array('order_id');
							$values = array("'".$order_id."'");
							$order_update_id = $obj->UpdateSQL($GLOBALS['order_table'], $order_insert_id, $columns, $values, '');
							if(preg_match("/^\d+$/", $order_update_id)) {
								$success = 1;
								$result = array('number' => '1', 'msg' => 'Order Successfully Created', 'order_id' => $order_id);
							}
							else {
								$result = array('number' => '2', 'msg' => $order_update_id);
							}
						}
						else {
							$result = array('number' => '2', 'msg' => $order_insert_id);
						}
					}
					else {
						$result = array('number' => '2', 'msg' => $order_error);
					}
				}
				else {
					if(empty($prev_order_id) || $prev_order_id == $edit_order_id) {
						$getUniqueID = "";
						$getUniqueID = $obj->getTableColumnValue($GLOBALS['order_table'], 'order_id', $edit_order_id, 'id');
						if(preg_match("/^\d+$/", $getUniqueID)) {
							$action = "";
							if(!empty($order_number)) {
								$action = "Order Updated. Order No - ".$obj->encode_decode('decrypt', $order_number);
							}
						
							$columns = array(); $values = array();						
							$columns = array('order_number', 'order_date', 'company_details', 'bank_details', 'customer_id', 'customer_details', 'customer_city', 'delivery_address', 'category_id', 'category_name', 'product_id', 'product_code', 'product_name', 'product_content', 'quantity', 'actual_price', 'price', 'discount', 'extra_discount', 'show_extra_discount_amount', 'minimum_order_amount', 'packing_charges', 'total_amount');
							$values = array("'".$order_number."'", "'".$order_date."'", "'".$company_details."'", "'".$bank_details."'", "'".$customer_id."'", "'".$customer_details."'", "'".$customer_city."'", "'".$delivery_address."'", "'".$category_ids."'", "'".$category_names."'", "'".$product_ids."'", "'".$product_codes."'", "'".$product_names."'", "'".$product_contents."'", "'".$quantity_values."'", "'".$actual_rate_values."'", "'".$rate_values."'", "'".$discount_values."'", "'".$extra_discount."'", "'".$show_extra_discount_amount."'", "'".$minimum_order_amount."'", "'".$packing_charges."'", "'".$total_amount."'");
							$discount_update_id = $obj->UpdateSQL($GLOBALS['order_table'], $getUniqueID, $columns, $values, $action);
							if(preg_match("/^\d+$/", $discount_update_id)) {			
								$result = array('number' => '1', 'msg' => 'Updated Successfully', 'order_id' => $edit_order_id);						
							}
							else {
								$result = array('number' => '2', 'msg' => $discount_update_id);
							}							
						}
					}
					else {
						$result = array('number' => '2', 'msg' => $discount_error);
					}
                }

				if(!empty($success) && $success == 1) {
					$notification_count = 0;
					$notification_count = $obj->CheckOrderNotifcationToSend();
				}

			}
			else {
				$result = array('number' => '2', 'msg' => 'Invalid IP');
			}
		}
		else {
			if(!empty($valid_direct_order)) {
				$result = array('number' => '3', 'msg' => $valid_direct_order);
			}
			else if(!empty($direct_order_error)) {
				$result = array('number' => '2', 'msg' => $direct_order_error);
			}
		}
		
		if(!empty($result)) {
			$result = json_encode($result);
		}
		echo $result; exit;

	}

	if(isset($_REQUEST['view_order_id'])) {
        $view_order_id = $_REQUEST['view_order_id'];
		$order_unique_id = "";
        if(!empty($view_order_id)) {
			$view_orders = array();
			$view_orders = $obj->getTableRecords($GLOBALS['order_table'], 'order_id', $view_order_id);
            if(!empty($view_orders)) {
                foreach($view_orders as $data) {
                    if(!empty($data['id'])) {
                        $order_unique_id = $data['id'];
					}
					if(!empty($data['product_id'])) {
						$product_ids = explode(",", $data['product_id']);
					}
                }
            }
			if(preg_match("/^\d+$/", $order_unique_id)) {
				$paper_size = "";
?>
				<div class="w-100 px-3">
					<div class="border card-box table-responsive">
						<div class="card-header px-2 py-2">
							<div class="row">
								<div class="col-3 text-center text-sm-left">
									<h5 class="headfnt">Enquiry Preview</h5>
								</div>
								<div class="col-sm-3">
									<select name="paper_size" id="paper_size" class="form-control" onchange="Javascript:show_pdf(this.value);">
										<option value="">Select Paper Size</option>
										<option value="a4" <?php if($paper_size == "a4"){ ?> selected <?php } ?>>A4</option>
										<?php if(count($product_ids)<=15){ ?><option value="a5" <?php if($paper_size == "a5"){ ?> selected <?php } ?>>A5</option><?php } ?>
										<option value="thermal" <?php if($paper_size == "thermal"){ ?> selected <?php } ?> >2 Inch</option>
										<option value="3inch" <?php if($paper_size == "3inch"){ ?> selected <?php } ?> >3 Inch</option>
									</select>
								</div>
								<div class="col-6 text-center text-sm-right">
									<div class="row">
										<div class="col-md-4">
											<div class="form-group">
												<button class="btn btn-dark poppins" style="font-size:11px;" type="button" id='btn_format1' onClick="window.open('reports/rpt_orders_format1.php?print_order_id=<?php echo $view_order_id; ?>&paper_size='+document.getElementById('paper_size').value,'_blank')"> <i class="fa fa-print"></i> &ensp; PDF Format 1</button>
											</div>
										</div>
										<div class="col-md-4">
											<div class="form-group">
												<button class="btn btn-dark poppins" style="font-size:11px;" type="button" id='btn_format2' onClick="window.open('reports/rpt_orders_format2.php?print_order_id=<?php echo $view_order_id; ?>&paper_size='+document.getElementById('paper_size').value,'_blank')"> <i class="fa fa-print"></i> &ensp; PDF Format 2</button>
											</div>
										</div>
										<div class="col-md-4">
											<div class="form-group">
												<button class="btn btn-dark poppins" style="font-size:11px;display:none" type="button" id='btn_thermal' onClick="window.open('reports/rpt_orders_format3.php?print_order_id=<?php echo $view_order_id; ?>&paper_size=','_blank')"> <i class="fa fa-print"></i> &ensp; PDF</button>
												&nbsp; <button class="btn btn-dark poppins" style="font-size:11px;display:none" type="button" id='btn_3inch' onClick="window.open('reports/rpt_orders_format4.php?print_order_id=<?php echo $view_order_id; ?>&paper_size=','_blank')"> <i class="fa fa-print"></i> &ensp; PDF</button>
												&nbsp; <button class="btn btn-danger poppins" style="font-size:11px;" type="button" onClick="window.open('order.php','_self')">Back</button>
											</div>
										</div>
									</div>
								</div>	
							</div>
						</div>
						<div class="card-body px-2 py-2">
							<script type="text/javascript" src="include/print_pdf/jspdf.min.js"></script>
							<script type="text/javascript" src="include/print_pdf/html2canvas.js"></script>
							<script type="text/javascript" src="include/print_pdf/print_pdf.js"></script>

							<?php 
								include("../order/order_print.php"); 
							?>

							<script>
								jQuery(document).ready(function() {
									prepare_print_view();        
								});
							</script>

						</div>
					</div>
				</div>
<?php				
			}
        }
    }

?>