<?php
    include "phpmailer.php";

    function common_validation($field_value, $field_name, $field_type) {
        $result = "";
        $field_value = trim($field_value);
        if(!empty($field_value)) {
            if(preg_match("/[\>\<]/", $field_value)) {
                $result = "(> <) not allowed";
            }
        }
        else {
            if($field_type == "select") {
                $result = "Select the ".$field_name;
            }
            else {
                $result = "Enter the ".$field_name;
            }
        }
        return $result;
    }

    function valid_mobile_number($field_value, $field_name, $required) {
        $result = "";
        $field_value = trim($field_value);
        if(!empty($field_value)) {
            $result = common_validation($field_value, $field_name, '');
            if(empty($result)) {
                if(!preg_match('/^[0-9]{10}$/', $field_value) && !preg_match('/^[0-9]{5}(\s)[0-9]{5}$/', $field_value)) {
                    $result = "Invalid ".$field_name;
                }
            }
        }
        else {
            if($required == 1) {
                $result = "Enter the ".$field_name;
            }
        }
        return $result;
    }

    function valid_email($field_value, $field_name, $required) {
        $result = "";
        $field_value = trim($field_value);
        if(!empty($field_value)) {
            $result = common_validation($field_value, $field_name, '');
            if(empty($result)) {
                if(!preg_match('/^([A-Za-z0-9_\-\.])+\@([A-Za-z0-9_\-\.])+\.([A-Za-z]{2,4})$/', $field_value)) {
                    $result = "Invalid ".$field_name;
                }
            }
        }
        else {
            if($required == 1) {
                $result = "Enter the ".$field_name;
            }
        }
        return $result;
    }

    function send_email_details($to_emails, $detail, $title) {

        if ( isset($_SERVER["OS"]) && $_SERVER["OS"] == "Windows_NT" ) {
            $hostname = strtolower($_SERVER["COMPUTERNAME"]);
        } else {
            $hostname = `hostname`;
            $hostnamearray = explode('.', $hostname);
            $hostname = $hostnamearray[0];
        }

        $mail = new PHPMailer();

        $mail->SMTPDebug = 0;  // Enable verbose debug output
        //SMTP settings start
        $mail->isSMTP(); // Set mailer to use SMTP
        if ( strpos($hostname, 'cpnl') === FALSE ) //if not cPanel
            $mail->Host = 'relay-hosting.secureserver.net';
        else
            $mail->Host = 'localhost';
            
        $mail->SMTPAuth = false; // Enable SMTP authentication
        $mail->From = 'admin@rubiiecotec.com';
        $mail -> FromName = 'Mail From Rubiiecotec.com';
        if(!empty($to_emails)) {
            foreach($to_emails as $key => $to) {
                if(!empty($key)) {
                    $mail->AddBCC($to);
                }
                if(empty($key)) {
                    $mail->addAddress($to);
                }
            }
        }
        $mail->Subject = $title;
        $mail->Body = $detail;

        $mailresult = $mail->Send();
        $mailconversation = nl2br(htmlspecialchars(ob_get_clean())); //captures the output of PHPMailer and htmlizes it
        if ( $mailresult ) {
            $msg = "Successfully Mail send";
        }
        else {
            $msg = 'FAIL: ' . $mail->ErrorInfo . '<br />' . $mailconversation;
        }
        return $msg;
    }

    function error_display($form_name, $field, $error, $type) {
        $result = "";
        if(!empty($error)) {
            if($type == "text") {
                $result = "if(jQuery('form[name=".'"'.$form_name.'"'."] input[name=".'"'.$field.'"'."]').parent().parent().find('span.infos').length == 0) {
                                jQuery('form[name=".'"'.$form_name.'"'."] input[name=".'"'.$field.'"'."]').parent().after('<span class=".'"infos"'."> <i class=".'"fa fa-exclamation-circle"'."></i>&nbsp;".$error."</span>');
                            }";
            }
            if($type == "textarea") {
                $result = "if(jQuery('form[name=".'"'.$form_name.'"'."] textarea[name=".'"'.$field.'"'."]').parent().parent().find('span.infos').length == 0) {
                                jQuery('form[name=".'"'.$form_name.'"'."] textarea[name=".'"'.$field.'"'."]').parent().after('<span class=".'"infos"'."> <i class=".'"fa fa-exclamation-circle"'."></i>&nbsp;".$error."</span>');
                            }";
            }
        }
        
        return $result;
    }

    if(isset($_POST['enquiry_customer_name'])) {
		$name = ""; $name_error = ""; $mobile_number = ""; $mobile_number_error = ""; $email = ""; $email_error = ""; $message = ""; $message_error = "";
		$valid_enquiry = ""; $form_name = "contact_form";

		$name = $_POST['enquiry_customer_name'];
		$name = trim($name);
		$name_error = common_validation($name, "Name", "text");
		if(!empty($name_error)) {
			$valid_enquiry = error_display($form_name, "enquiry_customer_name", $name_error, 'text');
		}

		$mobile_number = $_POST['mobile_number'];
		$mobile_number = trim($mobile_number);
		$mobile_number_error = valid_mobile_number($mobile_number, "Mobile number", "1");
		if(!empty($mobile_number_error)) {
			if(!empty($valid_enquiry)) {
				$valid_enquiry = $valid_enquiry." ".error_display($form_name, "mobile_number", $mobile_number_error, 'text');
			}
			else {
				$valid_enquiry = error_display($form_name, "mobile_number", $mobile_number_error, 'text');
			}
		}

		$email = $_POST['email'];
		$email = trim($email);
		$email_error = valid_email($email, "Email", "1");
		if(!empty($email_error)) {
			if(!empty($valid_enquiry)) {
				$valid_enquiry = $valid_enquiry." ".error_display($form_name, "email", $email_error, 'text');
			}
			else {
				$valid_enquiry = error_display($form_name, "email", $email_error, 'text');
			}
		}

		$message = $_POST['message'];
		$message = trim($message);
		$message_error = common_validation($message, "Message", "text");
		if(!empty($message_error)) {
			if(!empty($valid_enquiry)) {
				$valid_enquiry = $valid_enquiry." ".error_display($form_name, "message", $message_error, 'textarea');
			}
			else {
				$valid_enquiry = error_display($form_name, "message", $message_error, 'textarea');
			}
		}

		$result = "";
		
		if(empty($valid_enquiry)) {
			$enquity = "";
			$enquity = "<table cellpadding='0' cellspacing='0' class='table' style='border: 1px solid #d1d1d1;'>
				<tr>
					<td style='padding: 5px; border-bottom: 1px solid #d1d1d1; border-right: 1px solid #d1d1d1;'>Name &nbsp; : &nbsp; </td>
					<td style='padding: 5px; border-bottom: 1px solid #d1d1d1;'>".$name."</td>
				</tr>
				<tr>
					<td style='padding: 5px; border-bottom: 1px solid #d1d1d1; border-right: 1px solid #d1d1d1;'>E-mail Address &nbsp; : &nbsp; </td>
					<td style='padding: 5px; border-bottom: 1px solid #d1d1d1;'>".$email."</td>
				</tr>
				<tr>
					<td style='padding: 5px; border-bottom: 1px solid #d1d1d1; border-right: 1px solid #d1d1d1;'>Phone Number &nbsp; : &nbsp; </td>
					<td style='padding: 5px; border-bottom: 1px solid #d1d1d1;'>".$mobile_number."</td>
				</tr>
				<tr>
					<td style='padding: 5px; border-bottom: 1px solid #d1d1d1; border-right: 1px solid #d1d1d1;'>Message &nbsp; : &nbsp; </td>
					<td style='padding: 5px; border-bottom: 1px solid #d1d1d1;'>".$message."</td>
				</tr>
			</table>";
			
			$email_receive_from_customer = "rubiiecotec@gmail.com";
			/*$company_list = array();
			$company_list = $obj->getTableRecords($GLOBALS['company_table'], '', '', '');
            if(!empty($company_list)) {
                foreach($company_list as $data) {
					if(!empty($data['email']) && $data['email'] != $GLOBALS['null_value']) {
                        $email_receive_from_customer = $obj->encode_decode('decrypt', $data['email']);
					}
                }
            }*/
			
			if(!empty($email_receive_from_customer)) {
				$emails = array($email_receive_from_customer);
				$msg = send_email_details($emails, $enquity, "Enquiry");
				if($msg == "Successfully Mail send") {
					$msg = 1;
					$result = array('number' => '1', 'msg' => $msg);
				}
				else {
					$result = array('number' => '2', 'msg' => $msg);
				}	
			}
            
		}
		else {
			if(!empty($valid_enquiry)) {
				$result = array('number' => '3', 'msg' => $valid_enquiry);
			}
		}
		
		if(!empty($result)) {
			$result = json_encode($result);
		}
		echo $result; exit;
	}
?>