<?php
    class Billing_Functions extends Basic_Functions {
		public function CheckUnitNameAlreadyExists($unit_name) {
			$list = array(); $select_query = ""; $unit_id = "";
			if(!empty($unit_name)) {
				$select_query = "SELECT unit_id FROM ".$GLOBALS['unit_table']." WHERE lower_case_name = '".$unit_name."' AND deleted = '0'";	
			}
			//echo $select_query;
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['unit_table'], $select_query);
				if(!empty($list)) {
					foreach($list as $data) {
						if(!empty($data['unit_id'])) {
							$unit_id = $data['unit_id'];
						}
					}
				}
			}
			return $unit_id;
		}
		public function CheckDriverAlreadyExists($driver_name,$driver_number) {
			$list = array(); $select_query = ""; $driver_id = "";
			if(!empty($driver_name) && !empty($driver_number)) {
				$select_query = "SELECT driver_id FROM ".$GLOBALS['driver_table']." WHERE driver_number = '".$driver_number."' AND lower_case_name = '".$driver_name."' AND deleted = '0'";	
			}
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['driver_table'], $select_query);
				if(!empty($list)) {
					foreach($list as $data) {
						if(!empty($data['driver_id'])) {
							$driver_id = $data['driver_id'];
						}
					}
				}
			}
			return $driver_id;
		}
		public function checkVehicleNumberAlreadyExists($vehicle_number) {
			$list = array(); $select_query = ""; $vechile_id = "";
			if(!empty($vehicle_number)) {
				$select_query = "SELECT vehicle_id FROM ".$GLOBALS['vehicle_table']." WHERE lower_case_name = '".$vehicle_number."' AND deleted = '0'";	
			}
			//echo $select_query;
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['vehicle_table'], $select_query);
				if(!empty($list)) {
					foreach($list as $data) {
						if(!empty($data['vehicle_id'])) {
							$vechile_id = $data['vehicle_id'];
						}
					}
				}
			}
			return $vechile_id;
		}
		public function CheckBranchNameAlreadyExists($branch_name,$branch_city) {
			$list = array(); $select_query = ""; $branch_id = "";

			if(!empty($branch_name) && !empty($branch_city)) {
				$select_query = "SELECT * FROM ".$GLOBALS['branch_table']." WHERE lower_case_name = '".$branch_name."' AND lower_case_city = '".$branch_city."' AND deleted = '0'";	
			}
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['branch_table'], $select_query);
				if(!empty($list)) {
					foreach($list as $data) {
						if(!empty($data['id'])) {
							$branch_id = $data['id'];
						}
					}
				}
			}
			return $branch_id;
		}
		public function checkUserAlreadyExist($username,$edit_id) {
			$list = array(); $select_query = ""; $user_id ="";

			if(!empty($username)) {
				if(empty($edit_id))
				{
					$select_query ="SELECT * FROM ".$GLOBALS['user_table']." WHERE lower_case_name = '".$username."'  AND deleted = '0'";		
				}
				else
				{
					$select_query ="SELECT * FROM ".$GLOBALS['user_table']." WHERE lower_case_name = '".$username."'  AND deleted = '0' AND user_id != '".$edit_id."' ";	
				}
				
			}
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['user_table'], $select_query);
				if(!empty($list)) {
					foreach($list as $data) {
						if(!empty($data['id'])) {
							$user_id = $data['id'];
						}
					}
				}
			}
			if(empty($user_id))
			{
				if(!empty($username)) {
					if(empty($edit_id))
					{
						$select_query ="SELECT * FROM ".$GLOBALS['branch_staff_table']." WHERE lower_case_name = '".$username."'  AND deleted = '0'";		
					}
					else
					{
						$select_query ="SELECT * FROM ".$GLOBALS['branch_staff_table']." WHERE lower_case_name = '".$username."'  AND deleted = '0' AND staff_id != '".$edit_id."' ";	
					}
					
				}
				if(!empty($select_query)) {
					$list = $this->getQueryRecords($GLOBALS['staff_table'], $select_query);
					if(!empty($list)) {
						foreach($list as $data) {
							if(!empty($data['id'])) {
								$user_id = $data['id'];
							}
						}
					}
				}
			}
			if(empty($user_id))
			{
				if(!empty($username)) {
					if(empty($edit_id))
					{
						$select_query ="SELECT * FROM ".$GLOBALS['godown_staff_table']." WHERE lower_case_name = '".$username."'  AND deleted = '0'";		
					}
					else
					{
						$select_query ="SELECT * FROM ".$GLOBALS['godown_staff_table']." WHERE lower_case_name = '".$username."'  AND deleted = '0' AND staff_id != '".$edit_id."' ";	
					}
					
				}
				if(!empty($select_query)) {
					$list = $this->getQueryRecords($GLOBALS['staff_table'], $select_query);
					if(!empty($list)) {
						foreach($list as $data) {
							if(!empty($data['id'])) {
								$user_id = $data['id'];
							}
						}
					}
				}
			}
			return $user_id;
		}
		
		public function CheckBranchLrAlreadyExists($branch_lr_prefix) {
			$list = array(); $select_query = ""; $branch_id = "";

			if(!empty($branch_lr_prefix)) {
				$select_query = "SELECT * FROM ".$GLOBALS['branch_table']." WHERE branch_lr_prefix = '".$branch_lr_prefix."' AND deleted = '0'";	
			}
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['branch_table'], $select_query);
				if(!empty($list)) {
					foreach($list as $data) {
						if(!empty($data['id'])) {
							$branch_id = $data['id'];
						}
					}
				}
			}
			return $branch_id;
		}

		public function CheckBranchMobileAlreadyExists($branch_contact_number) {
			$list = array(); $select_query = ""; $branch_id = "";

			if(!empty($branch_contact_number)) {
				$select_query = "SELECT * FROM ".$GLOBALS['branch_table']." WHERE branch_contact_number = '".$branch_contact_number."' AND deleted = '0'";	
			}
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['branch_table'], $select_query);
				if(!empty($list)) {
					foreach($list as $data) {
						if(!empty($data['id'])) {
							$branch_id = $data['id'];
						}
					}
				}
			}
			return $branch_id;
		}

		public function getTrackLRnumberDetailsList($from_date, $to_date, $lr_number) {
			$list = array(); $select_query = ""; $where = "";

			if(!empty($lr_number)) {
				$where = "lr_number = '".$lr_number."'";
			}
			if(!empty($from_date)) {
				$from_date = date("Y-m-d", strtotime($from_date));
				if(!empty($where)) {
					$where = $where." AND lr_date >= '".$from_date."'";
				}
				else {
					$where = "lr_date >= '".$from_date."'";
				}
			}
			if(!empty($to_date)) {
				$to_date = date("Y-m-d", strtotime($to_date));
				if(!empty($where)) {
					$where = $where." AND lr_date <= '".$to_date."'";
				}
				else {
					$where = "lr_date <= '".$to_date."'";
				}
			}

			if(!empty($where)) {
				$select_query = "SELECT * FROM ".$GLOBALS['lr_table']." WHERE ".$where." AND deleted = '0'";
				$list = $this->getQueryRecords($GLOBALS['lr_table'], $select_query);	
			}
			return $list;
		}

		public function getLRDetailsList($bill_company_id,$organization_id, $branch_id,$consignee_id,$consignor_id,$bill_type,$status,$from_date, $to_date,$godown_id) {
			$list = array(); $select_query = ""; $where = "";

			// if(!empty($bill_company_id)) {
			// 	$where = "bill_company_id = '".$bill_company_id."'";
			// }
			if(!empty($bill_type)) {
				if(!empty($where)) {
					$where = $where." AND bill_type = '".$bill_type."'";
				}
				else {
					$where = "bill_type = '".$bill_type."'";
				}
			}
			if(!empty($godown_id)) {
				if(!empty($where)) {
					$where = $where." AND godown_id = '".$godown_id."'";
				}
				else {
					$where = "godown_id = '".$godown_id."'";
				}	
			}
			if(!empty($organization_id)) {
				if(!empty($where)) {
					$where = $where." AND organization_id = '".$organization_id."'";
				}
				else {
					$where = "organization_id = '".$organization_id."'";
				}
			}
			if(!empty($consignee_id)) {
				if(!empty($where)) {
					$where = $where." AND consignee_id = '".$consignee_id."'";
				}
				else {
					$where = "consignee_id = '".$consignee_id."'";
				}
			}
			if(!empty($consignor_id)) {
				if(!empty($where)) {
					$where = $where." AND consignor_id = '".$consignor_id."'";
				}
				else {
					$where = "consignor_id = '".$consignor_id."'";
				}
			}
			if(!empty($branch_id)) {
				if(!empty($where)) {
					$where = $where." AND branch_id = '".$branch_id."'";
				}
				else {
					$where = "branch_id = '".$branch_id."'";
				}
			}
			if(!empty($from_date)) {
				$from_date = date("Y-m-d", strtotime($from_date));
				if(!empty($where)) {
					$where = $where." AND lr_date >= '".$from_date."'";
				}
				else {
					$where = "lr_date >= '".$from_date."'";
				}
			}
			if(!empty($to_date)) {
				$to_date = date("Y-m-d", strtotime($to_date));
				if(!empty($where)) {
					$where = $where." AND lr_date <= '".$to_date."'";
				}
				else {
					$where = "lr_date <= '".$to_date."'";
				}
			}
			if($status == "1") {

				if(!empty($where)) {
					$select_query = "SELECT * FROM ".$GLOBALS['lr_table']." WHERE ".$where." AND deleted = '0' AND cancelled = '1' ORDER BY DATE(lr_date) DESC, id DESC";	
				}
				else
				{
					$select_query = "SELECT * FROM ".$GLOBALS['lr_table']." WHERE  deleted = '0'  AND cancelled = '1' ORDER BY DATE(lr_date) DESC, id DESC";	
				}
				if(!empty($select_query)) {
					$list = $this->getQueryRecords($GLOBALS['lr_table'], $select_query);
				}
			}
			else
			{
				if(!empty($where)) {
					$select_query = "SELECT * FROM ".$GLOBALS['lr_table']." WHERE ".$where." AND deleted = '0' AND cancelled = '0' ORDER BY DATE(lr_date) DESC, id DESC";	
				}
				else
				{
					$select_query = "SELECT * FROM ".$GLOBALS['lr_table']." WHERE  deleted = '0'  AND cancelled = '0' ORDER BY DATE(lr_date) DESC, id DESC";	
				}
				//echo $select_query;
				if(!empty($select_query)) {
					$list = $this->getQueryRecords($GLOBALS['lr_table'], $select_query);
				}
			}
			return $list;
		}
		public function LrTripsheetUpdate($lr_id,$tripsheet_number) {
			$getUniqueId = $this->getTableColumnValue($GLOBALS['lr_table'],'lr_id',$lr_id,'id');
			$columns = array(); $values = array();          		
			$columns = array('is_tripsheet_entry','tripsheet_number');
			$values = array("'1'","'".$tripsheet_number."'");
			$list = $this->UpdateSQL($GLOBALS['lr_table'], $getUniqueId, $columns, $values,'');
			return $list;
		}
		public function getClearanceReportCount($bill_company_id,$organization_id, $branch_id,$consignee_id,$consignor_id,$bill_type,$status,$from_date, $to_date,$godown_id, $search_lr_number) {
			$lr_count = 0; $list = array(); $select_query = ""; $where = "";

			// if(!empty($bill_company_id)) {
			// 	$where = "bill_company_id = '".$bill_company_id."'";
			// }
			if(!empty($bill_type)) {
				if(!empty($where)) {
					$where = $where." AND bill_type = '".$bill_type."'";
				}
				else {
					$where = "bill_type = '".$bill_type."'";
				}
			}
			if(!empty($godown_id))
			{
				if(!empty($where)) {
					$where = $where." AND godown_id = '".$godown_id."'";
				}
				else {
					$where = "godown_id = '".$godown_id."'";
				}	
			}
			if(!empty($organization_id)) {
				if(!empty($where)) {
					$where = $where." AND organization_id = '".$organization_id."'";
				}
				else {
					$where = "organization_id = '".$organization_id."'";
				}
			}
			if(!empty($consignee_id)) {
				if(!empty($where)) {
					$where = $where." AND consignee_id = '".$consignee_id."'";
				}
				else {
					$where = "consignee_id = '".$consignee_id."'";
				}
			}
			if(!empty($consignor_id)) {
				if(!empty($where)) {
					$where = $where." AND consignor_id = '".$consignor_id."'";
				}
				else {
					$where = "consignor_id = '".$consignor_id."'";
				}
			}
			if(!empty($branch_id)) {
				if(!empty($where)) {
					$where = $where." AND branch_id = '".$branch_id."'";
				}
				else {
					$where = "branch_id = '".$branch_id."'";
				}
			}
			if(!empty($from_date)) {
				$from_date = date("Y-m-d", strtotime($from_date));
				if(!empty($where)) {
					$where = $where." AND lr_date >= '".$from_date."'";
				}
				else {
					$where = "lr_date >= '".$from_date."'";
				}
			}
			if(!empty($to_date)) {
				$to_date = date("Y-m-d", strtotime($to_date));
				if(!empty($where)) {
					$where = $where." AND lr_date <= '".$to_date."'";
				}
				else {
					$where = "lr_date <= '".$to_date."'";
				}
			}
			if(!empty($search_lr_number)) {
				if(!empty($where)) {
					$where = $where." AND lr_number = '".$search_lr_number."'";
				}
				else {
					$where = "lr_number = '".$search_lr_number."'";
				}
			}
			
			if(!empty($where)) {
				if(!empty($search_lr_number)) {
					$select_query = "SELECT COUNT(id) as lr_count FROM ".$GLOBALS['lr_table']." WHERE ".$where." AND deleted = '0' AND cancelled = '0' AND is_cleared =  '1'";
				}
				else {
					$select_query = "SELECT COUNT(id) as lr_count FROM ".$GLOBALS['lr_table']." WHERE ".$where." AND deleted = '0' AND cancelled = '0' AND is_cleared =  '1'";
				}	
			}
			else
			{
				$select_query = "SELECT COUNT(id) as lr_count FROM ".$GLOBALS['lr_table']." WHERE  deleted = '0'  AND cancelled = '0' AND is_cleared =  '1'";	
			}
			//echo $select_query; exit;
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['lr_table'], $select_query);
				if(!empty($list)) {
					foreach($list as $data) {
						if(!empty($data['lr_count'])) {
							$lr_count = $data['lr_count'];
						}
					}
				}
			}
			return $lr_count;
		}
		public function getClearanceReportList($bill_company_id,$organization_id, $branch_id,$consignee_id,$consignor_id,$bill_type,$status,$from_date, $to_date,$godown_id, $search_lr_number, $page_number, $page_limit, $total_lr_count) {
			$list = array(); $select_query = ""; $where = "";

			// if(!empty($bill_company_id)) {
			// 	$where = "bill_company_id = '".$bill_company_id."'";
			// }
			if(!empty($bill_type)) {
				if(!empty($where)) {
					$where = $where." AND bill_type = '".$bill_type."'";
				}
				else {
					$where = "bill_type = '".$bill_type."'";
				}
			}
			if(!empty($godown_id))
			{
				if(!empty($where)) {
					$where = $where." AND godown_id = '".$godown_id."'";
				}
				else {
					$where = "godown_id = '".$godown_id."'";
				}	
			}
			if(!empty($organization_id)) {
				if(!empty($where)) {
					$where = $where." AND organization_id = '".$organization_id."'";
				}
				else {
					$where = "organization_id = '".$organization_id."'";
				}
			}
			if(!empty($consignee_id)) {
				if(!empty($where)) {
					$where = $where." AND consignee_id = '".$consignee_id."'";
				}
				else {
					$where = "consignee_id = '".$consignee_id."'";
				}
			}
			if(!empty($consignor_id)) {
				if(!empty($where)) {
					$where = $where." AND consignor_id = '".$consignor_id."'";
				}
				else {
					$where = "consignor_id = '".$consignor_id."'";
				}
			}
			if(!empty($branch_id)) {
				if(!empty($where)) {
					$where = $where." AND branch_id = '".$branch_id."'";
				}
				else {
					$where = "branch_id = '".$branch_id."'";
				}
			}
			if(!empty($from_date)) {
				$from_date = date("Y-m-d", strtotime($from_date));
				if(!empty($where)) {
					$where = $where." AND lr_date >= '".$from_date."'";
				}
				else {
					$where = "lr_date >= '".$from_date."'";
				}
			}
			if(!empty($to_date)) {
				$to_date = date("Y-m-d", strtotime($to_date));
				if(!empty($where)) {
					$where = $where." AND lr_date <= '".$to_date."'";
				}
				else {
					$where = "lr_date <= '".$to_date."'";
				}
			}
			if(!empty($search_lr_number)) {
				if(!empty($where)) {
					$where = $where." AND lr_number = '".$search_lr_number."'";
				}
				else {
					$where = "lr_number = '".$search_lr_number."'";
				}
			}

			$page_start = 0; $page_end = 0;
			if(!empty($total_lr_count)) {				
				if($total_lr_count > $page_limit) {
					if(!empty($page_number)) {
						$page_start = ($page_number - 1) * $page_limit;
						$page_end = $page_limit;
					}
					else {
						$page_start = 0;
						$page_end = $page_limit;
					}
				}
				else {
					$page_start = 0;
					$page_end = $page_limit;
				}
			}
			
			if(!empty($where)) {
				if(!empty($search_lr_number)) {
					$select_query = "SELECT * FROM ".$GLOBALS['lr_table']." WHERE ".$where." AND deleted = '0' AND cancelled = '0' AND is_cleared =  '1'";
				}
				else {
					$select_query = "SELECT * FROM ".$GLOBALS['lr_table']." WHERE ".$where." AND deleted = '0' AND cancelled = '0' AND is_cleared =  '1' 
										ORDER BY id DESC LIMIT ".$page_start.", ".$page_end;
				}	
			}
			else
			{
				$select_query = "SELECT * FROM ".$GLOBALS['lr_table']." WHERE  deleted = '0'  AND cancelled = '0' AND is_cleared =  '1' 
									ORDER BY id DESC LIMIT ".$page_start.", ".$page_end;	
			}
			//echo $select_query; exit;
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['lr_table'], $select_query);
			}
			return $list;
		}
		public function getUnClearanceReportList($bill_company_id,$organization_id, $branch_id,$consignee_id,$consignor_id,$bill_type,$status,$from_date, $to_date,$godown_id) {
			$list = array(); $select_query = ""; $where = "";

			// if(!empty($bill_company_id)) {
			// 	$where = "bill_company_id = '".$bill_company_id."'";
			// }
			if(!empty($bill_type)) {
				if(!empty($where)) {
					$where = $where." AND bill_type = '".$bill_type."'";
				}
				else {
					$where = "bill_type = '".$bill_type."'";
				}
			}
			if(!empty($godown_id))
			{
				if(!empty($where)) {
					$where = $where." AND godown_id = '".$godown_id."'";
				}
				else {
					$where = "godown_id = '".$godown_id."'";
				}	
			}
			if(!empty($organization_id)) {
				if(!empty($where)) {
					$where = $where." AND organization_id = '".$organization_id."'";
				}
				else {
					$where = "organization_id = '".$organization_id."'";
				}
			}
			if(!empty($consignee_id)) {
				if(!empty($where)) {
					$where = $where." AND consignee_id = '".$consignee_id."'";
				}
				else {
					$where = "consignee_id = '".$consignee_id."'";
				}
			}
			if(!empty($consignor_id)) {
				if(!empty($where)) {
					$where = $where." AND consignor_id = '".$consignor_id."'";
				}
				else {
					$where = "consignor_id = '".$consignor_id."'";
				}
			}
			if(!empty($branch_id)) {
				if(!empty($where)) {
					$where = $where." AND branch_id = '".$branch_id."'";
				}
				else {
					$where = "branch_id = '".$branch_id."'";
				}
			}
			if(!empty($from_date)) {
				$from_date = date("Y-m-d", strtotime($from_date));
				if(!empty($where)) {
					$where = $where." AND lr_date >= '".$from_date."'";
				}
				else {
					$where = "lr_date >= '".$from_date."'";
				}
			}
			if(!empty($to_date)) {
				$to_date = date("Y-m-d", strtotime($to_date));
				if(!empty($where)) {
					$where = $where." AND lr_date <= '".$to_date."'";
				}
				else {
					$where = "lr_date <= '".$to_date."'";
				}
			}
			
			if(!empty($where)) {
				$select_query = "SELECT * FROM ".$GLOBALS['lr_table']." WHERE ".$where." AND deleted = '0' AND cancelled = '0' AND is_cleared =  '0' AND is_tripsheet_entry = '1' ORDER BY id DESC";	
			}
			else
			{
				$select_query = "SELECT * FROM ".$GLOBALS['lr_table']." WHERE  deleted = '0'  AND cancelled = '0' AND is_cleared =  '0' AND is_tripsheet_entry = '1' ORDER BY id DESC";	
			}
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['lr_table'], $select_query);
			}
			return $list;
		}
		public function getIncoiceDetailsList($organization_id,$consignor_id,$branch_id,$status,$from_date,$to_date) {
			$list = array(); $select_query = ""; $where = "";

			// if(!empty($bill_company_id)) {
			// 	$where = "bill_company_id = '".$bill_company_id."'";
			// }
			// if(!empty($bill_type)) {
			// 	if(!empty($where)) {
			// 		$where = $where." AND bill_type = '".$bill_type."'";
			// 	}
			// 	else {
			// 		$where = "bill_type = '".$bill_type."'";
			// 	}
			// }
			if(!empty($organization_id)) {
				if(!empty($where)) {
					$where = $where." AND organization_id = '".$organization_id."'";
				}
				else {
					$where = "organization_id = '".$organization_id."'";
				}
			}
			if(!empty($consignee_id)) {
				if(!empty($where)) {
					$where = $where." AND consignee_id = '".$consignee_id."'";
				}
				else {
					$where = "consignee_id = '".$consignee_id."'";
				}
			}
			if(!empty($branch_id)) {
				if(!empty($where)) {
					$where = $where." AND branch_id = '".$branch_id."'";
				}
				else {
					$where = "branch_id = '".$branch_id."'";
				}
			}
			if(!empty($from_date)) {
				$from_date = date("Y-m-d", strtotime($from_date));
				if(!empty($where)) {
					$where = $where." AND invoice_date >= '".$from_date."'";
				}
				else {
					$where = "invoice_date >= '".$from_date."'";
				}
			}
			if(!empty($to_date)) {
				$to_date = date("Y-m-d", strtotime($to_date));
				if(!empty($where)) {
					$where = $where." AND invoice_date <= '".$to_date."'";
				}
				else {
					$where = "invoice_date <= '".$to_date."'";
				}
			}
			if($status == '1')
			{
				if(!empty($where)) {
					$select_query = "SELECT * FROM ".$GLOBALS['invoice_table']." WHERE ".$where." AND deleted = '0' AND cancelled = '1'  ORDER BY id DESC";	
				}
				else
				{
					$select_query = "SELECT * FROM ".$GLOBALS['invoice_table']." WHERE  deleted = '0' AND cancelled = '1'  ORDER BY id DESC";	
				}
				if(!empty($select_query)) {
					$list = $this->getQueryRecords($GLOBALS['invoice_table'], $select_query);
				}
			}
			else
			{
				if(!empty($where)) {
					$select_query = "SELECT * FROM ".$GLOBALS['invoice_table']." WHERE ".$where." AND deleted = '0' AND cancelled = '0'  ORDER BY id DESC";	
				}
				else
				{
					$select_query = "SELECT * FROM ".$GLOBALS['invoice_table']." WHERE  deleted = '0' AND cancelled = '0'  ORDER BY id DESC";	
				}
				if(!empty($select_query)) {
					$list = $this->getQueryRecords($GLOBALS['invoice_table'], $select_query);
				}
			}
			
			return $list;
		}
		public function LrClearance($lr_id) {
			$getUniqueId = $this->getTableColumnValue($GLOBALS['lr_table'],'lr_id',$lr_id,'id');
			$columns = array(); $values = array();          		
			$columns = array('is_tripsheet_entry');
			$values = array("'1'");
			$list = $this->UpdateSQL($GLOBALS['lr_table'], $getUniqueId, $columns, $values,'');
			return $list;
		}
		public function getTripsheetDetailsList($consignor_id,$godown_id,$from_date,$to_date) {
			$list = array(); $select_query = ""; $where = "";

			if(!empty($consignor_id)) {
				if(!empty($where)) {
					$where = $where." AND consignor_id = '".$consignor_id."'";
				}
				else {
					$where = "consignor_id = '".$consignor_id."'";
				}
			}
			if(!empty($godown_id)) {
				if(!empty($where)) {
					$where = $where." AND godown_id = '".$godown_id."'";
				}
				else {
					$where = "godown_id = '".$godown_id."'";
				}
			}
			if(!empty($from_date)) {
				$from_date = date("Y-m-d", strtotime($from_date));
				if(!empty($where)) {
					$where = $where." AND tripsheet_date >= '".$from_date."'";
				}
				else {
					$where = "tripsheet_date >= '".$from_date."'";
				}
			}
			if(!empty($to_date)) {
				$to_date = date("Y-m-d", strtotime($to_date));
				if(!empty($where)) {
					$where = $where." AND tripsheet_date <= '".$to_date."'";
				}
				else {
					$where = "tripsheet_date <= '".$to_date."'";
				}
			}
			
			if(!empty($where)) {
				$select_query = "SELECT * FROM ".$GLOBALS['tripsheet_table']." WHERE ".$where." AND deleted = '0' AND cancelled = '0'  ORDER BY id DESC";	
			}
			else
			{
				$select_query = "SELECT * FROM ".$GLOBALS['tripsheet_table']." WHERE  deleted = '0' AND cancelled = '0'  ORDER BY id DESC";	
			}
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['tripsheet_table'], $select_query);
			}
			
			// else
			// {
			// 	if(!empty($where)) {
			// 		$select_query = "SELECT * FROM ".$GLOBALS['invoice_table']." WHERE ".$where." AND deleted = '0' AND cancelled = '0'  ORDER BY id DESC";	
			// 	}
			// 	else
			// 	{
			// 		$select_query = "SELECT * FROM ".$GLOBALS['invoice_table']." WHERE  deleted = '0' AND cancelled = '0'  ORDER BY id DESC";	
			// 	}
			// 	if(!empty($select_query)) {
			// 		$list = $this->getQueryRecords($GLOBALS['invoice_table'], $select_query);
			// 	}
			// }
			
			return $list;
		}
		public function getLuggagesheetList($consignor_id,$branch_id,$status,$from_date,$to_date) {
			$list = array(); $select_query = ""; $where = "";

			
			if(!empty($consignor_id)) {
				if(!empty($where)) {
					$where = $where." AND consignor_id = '".$consignor_id."'";
				}
				else {
					$where = "consignor_id = '".$consignor_id."'";
				}
			}
			if(!empty($branch_id)) {
				if(!empty($where)) {
					$where = $where." AND branch_id = '".$branch_id."'";
				}
				else {
					$where = "branch_id = '".$branch_id."'";
				}
			}
			// if(!empty($from_date)) {
			// 	$from_date = date("Y-m-d", strtotime($from_date));
			// 	if(!empty($where)) {
			// 		$where = $where." AND luggage_date >= '".$from_date."'";
			// 	}
			// 	else {
			// 		$where = "luggage_date >= '".$from_date."'";
			// 	}
			// }
			// if(!empty($to_date)) {
			// 	$to_date = date("Y-m-d", strtotime($to_date));
			// 	if(!empty($where)) {
			// 		$where = $where." AND luggage_date <= '".$to_date."'";
			// 	}
			// 	else {
			// 		$where = "luggage_date <= '".$to_date."'";
			// 	}
			// }
			if($status == '1')
			{
				if(!empty($where)) {
					$select_query = "SELECT * FROM ".$GLOBALS['luggagesheet_table']." WHERE ".$where." AND deleted = '0' AND cancelled = '1'  ORDER BY id DESC";	
				}
				else
				{
					echo $select_query = "SELECT * FROM ".$GLOBALS['luggagesheet_table']." WHERE  deleted = '0' AND cancelled = '1'  ORDER BY id DESC";	
				}
				if(!empty($select_query)) {
					$list = $this->getQueryRecords($GLOBALS['luggagesheet_table'], $select_query);
				}
			}
			else
			{
				if(!empty($where)) {
					$select_query = "SELECT * FROM ".$GLOBALS['luggagesheet_table']." WHERE ".$where." AND deleted = '0' AND cancelled = '0'  ORDER BY id DESC";	
				}
				else
				{
					$select_query = "SELECT * FROM ".$GLOBALS['luggagesheet_table']." WHERE  deleted = '0' AND cancelled = '0'  ORDER BY id DESC";	
				}
				if(!empty($select_query)) {
					$list = $this->getQueryRecords($GLOBALS['luggagesheet_table'], $select_query);
				}
			}
			
			return $list;
		}
		public function UpdateLuggage($luggage_id) {
			$getUniqueId = $this->getTableColumnValue($GLOBALS['luggagesheet_table'],'luggage_id',$luggage_id,'id');
			$columns = array(); $values = array();          		
			$columns = array('is_cleared');
			$values = array("'1'");
			$list = $this->UpdateSQL($GLOBALS['luggagesheet_table'], $getUniqueId, $columns, $values,'');
			return $list;
		}
		public function getClearedLuggagesheetLR($luggage_id)
		{
			$luggagesheet_number = $this->getTableColumnValue($GLOBALS['luggagesheet_table'],'luggage_id',$luggage_id,'luggagesheet_number');
			$select_query ="";
			$select_query = "SELECT * FROM ".$GLOBALS['lr_table']." WHERE  luggagesheet_number = '".$luggagesheet_number."' AND is_tripsheet_entry = '1' ";
			$luggage_lr_list = $this->getQueryRecords('',$select_query);
			return $luggage_lr_list;
		}
		public function getLR($table) {
			$from_date = ""; $to_date = "";
			if(isset($_SESSION['billing_year_starting_date']) && !empty($_SESSION['billing_year_starting_date'])) {
				$from_date = $_SESSION['billing_year_starting_date'];
				if(!empty($from_date)) {
					$from_date = date("Y-m-d", strtotime($from_date));
				}
			}			
			if(isset($_SESSION['billing_year_ending_date']) && !empty($_SESSION['billing_year_ending_date'])) {
				$to_date = $_SESSION['billing_year_ending_date'];
				if(!empty($to_date)) {
					$to_date = date("Y-m-d", strtotime($to_date));
				}
			}
			if(!empty($from_date) && !empty($to_date)) {
				$select_query = "SELECT * FROM ".$GLOBALS['lr_table']." WHERE DATE(lr_date) >= '".$from_date."' AND DATE(lr_date) <= '".$to_date."' AND godown_id = '' 
									AND is_luggage_entry = '0' AND deleted = '0'  AND is_tripsheet_entry = '0' AND is_cleared = 0 ";
				$lr_list = $this->getQueryRecords('',$select_query);
			}
			return $lr_list;
		}
		public function getLRbranchwise($lr_number)
		{
			$lr_list = "";
			if(!empty($lr_number)){
				if($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_type'] == $GLOBALS['branch_staff_user_type']) {
					$staff_id = $_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id'];
					if(!empty($staff_id))
					{
						$branch_id = $this->getTableColumnValue($GLOBALS['branch_staff_table'],'staff_id',$staff_id,'branch_id');
						$branch_id = "'" . str_replace(",", "','", $branch_id) . "'";
					}
					$select_query = ""; 
					$select_query = "SELECT * FROM ".$GLOBALS['lr_table']." WHERE lr_number = '".$lr_number."' AND branch_id = ".$branch_id." AND deleted = '0'";
					if(!empty($select_query)){
						$lr_list = $this->getQueryRecords('',$select_query);
					}
				}
				else{
					$select_query = ""; 
					$select_query = "SELECT * FROM ".$GLOBALS['lr_table']." WHERE lr_number = '".$lr_number."' AND deleted = '0'";
					$lr_list = $this->getQueryRecords('',$select_query);
				}
			}
			
			if(!empty($lr_list)){
				return $lr_list;
			}
		}
		public function getLRIDbranchwise($lr_number)
		{
			$lr_list = "";
			if(!empty($lr_number)){
				if($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_type'] == $GLOBALS['branch_staff_user_type']) {
					$staff_id = $_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id'];
					if(!empty($staff_id))
					{
						$branch_id = $this->getTableColumnValue($GLOBALS['branch_staff_table'],'staff_id',$staff_id,'branch_id');
						$branch_id = "'" . str_replace(",", "','", $branch_id) . "'";
					}
					$select_query = ""; 
					$select_query = "SELECT id FROM ".$GLOBALS['lr_table']." WHERE lr_number = '".$lr_number."' AND branch_id = ".$branch_id." AND deleted = '0'";
					if(!empty($select_query)){
						$lr_list = $this->getQueryRecords('',$select_query);
						if(!empty($lr_list)){
							foreach($lr_list as $list){
								if(!empty($list['id'])){
									$lr_id = $list['id'];
								}
							}
						}
					}
				}
				else{
					$select_query = ""; 
					$select_query = "SELECT id FROM ".$GLOBALS['lr_table']." WHERE lr_number = '".$lr_number."' AND deleted = '0'";
					if(!empty($select_query)){
						$lr_list = $this->getQueryRecords('',$select_query);
						if(!empty($lr_list)){
							foreach($lr_list as $list){
								if(!empty($list['id'])){
									$lr_id = $list['id'];
								}
							}
						}
					}
				}
			}
			if(!empty($lr_id)){
				return $lr_id;
			}
		}
		public function getUnClearencelLrList($branch_id)
		{
			$from_date = ""; $to_date = "";
			if(isset($_SESSION['billing_year_starting_date']) && !empty($_SESSION['billing_year_starting_date'])) {
				$from_date = $_SESSION['billing_year_starting_date'];
				if(!empty($from_date)) {
					$from_date = date("Y-m-d", strtotime($from_date));
				}
			}			
			if(isset($_SESSION['billing_year_ending_date']) && !empty($_SESSION['billing_year_ending_date'])) {
				$to_date = $_SESSION['billing_year_ending_date'];
				if(!empty($to_date)) {
					$to_date = date("Y-m-d", strtotime($to_date));
				}
			}
			if(!empty($branch_id) && !empty($from_date) && !empty($to_date)) {
				$lr_list = array();
				$select_query = "SELECT * FROM ".$GLOBALS['lr_table']." WHERE DATE(lr_date) >= '".$from_date."' AND DATE(lr_date) = '".$to_date."' 
									AND is_tripsheet_entry = '1' AND is_cleared = '0' AND branch_id = '".$branch_id."' AND deleted ='0' ";
				$lr_list = $this->getQueryRecords($GLOBALS['lr_table'],$select_query);
			}
			else if(!empty($from_date) && !empty($to_date)) {
				$lr_list = array();
				$select_query = "SELECT * FROM ".$GLOBALS['lr_table']." WHERE DATE(lr_date) >= '".$from_date."' AND DATE(lr_date) <= '".$to_date."' 
									AND is_tripsheet_entry = '1' AND is_cleared = '0' AND deleted ='0' ";
				$lr_list = $this->getQueryRecords($GLOBALS['lr_table'],$select_query);
			}
			return $lr_list;
		}
		public function organizationDetails($organization_id, $table) {
			$bill_company_details = "";
			// if(!empty($organization_id)) {
				$check_organization = array();
				$check_organization = $this->getTableRecords($GLOBALS['organization_table'], '','');
				if(!empty($check_organization)) {
					foreach($check_organization as $data) {
				
						if(!empty($data['name'])) {
							$bill_company_details = $this->encode_decode('decrypt', $data['name']);
						}
						if(!empty($data['address_line1']) && $data['address_line1'] != $GLOBALS['null_value']) {
							$bill_company_details = $bill_company_details."$$$".$this->encode_decode('decrypt', $data['address_line1']);
						}
						else
						{
							$bill_company_details = $bill_company_details."$$$".$GLOBALS['null_value'];	
						}
						if(!empty($data['address_line2']) && $data['address_line2'] != $GLOBALS['null_value']) {
							$bill_company_details = $bill_company_details."$$$".$this->encode_decode('decrypt', $data['address_line2']);
						}
						else
						{
							$bill_company_details = $bill_company_details."$$$".$GLOBALS['null_value'];	
						}
						if(!empty($data['city']) && $data['city'] != $GLOBALS['null_value']) {
							$bill_company_details = $bill_company_details."$$$".$this->encode_decode('decrypt', $data['city']);
						}
						else
						{
							$bill_company_details = $bill_company_details."$$$".$GLOBALS['null_value'];	
						}
						if(!empty($data['pincode']) && $data['pincode'] != $GLOBALS['null_value']) {
							$bill_company_details = $bill_company_details."$$$".$this->encode_decode('decrypt', $data['pincode']);
						}
						else
						{
							$bill_company_details = $bill_company_details."$$$".$GLOBALS['null_value'];	
						}
						if(!empty($data['state']) && $data['state'] != $GLOBALS['null_value']) {
							$bill_company_details = $bill_company_details."$$$".$this->encode_decode('decrypt', $data['state']);
						}
						else
						{
							$bill_company_details = $bill_company_details."$$$".$GLOBALS['null_value'];	
						}
						if(!empty($data['gst_number']) && $data['gst_number'] != $GLOBALS['null_value']) {
							$bill_company_details = $bill_company_details."$$$".$this->encode_decode('decrypt', $data['gst_number']);
						}
						else {
							$bill_company_details = $bill_company_details."$$$".$GLOBALS['null_value'];
						}
						if(!empty($data['mobile_number']) && $data['mobile_number'] != $GLOBALS['null_value']) {
							$bill_company_details = $bill_company_details."$$$".$this->encode_decode('decrypt', $data['mobile_number']);
						}
						else {
							$bill_company_details = $bill_company_details."$$$".$GLOBALS['null_value'];
						}
					}
				}
				if(!empty($bill_company_details)) {
					$bill_company_details = $this->encode_decode('encrypt', $bill_company_details);
				}
			// }
			return $bill_company_details;
		}
		public function getGodownReport($filter_godown_id,$from_date,$to_date,$branch_id) {
			$list = array(); $select_query = ""; $where = "";

			if(!empty($filter_godown_id)) {
				$where = "godown_id = '".$filter_godown_id."'";
			}
			if(!empty($branch_id)) {
				if(!empty($where)) {
					$where = $where."branch_id = '".$branch_id."'";
				}
				else {
					$where = "branch_id = '".$branch_id."'";
				}
			}
			if(!empty($from_date)) {
				$from_date = date("Y-m-d", strtotime($from_date));
				if(!empty($where)) {
					$where = $where." AND lr_date >= '".$from_date."'";
				}
				else {
					$where = "lr_date >= '".$from_date."'";
				}
			}
			if(!empty($to_date)) {
				$to_date = date("Y-m-d", strtotime($to_date));
				if(!empty($where)) {
					$where = $where." AND lr_date <= '".$to_date."'";
				}
				else {
					$where = "lr_date <= '".$to_date."'";
				}
			}
			
			if(!empty($where)) {
				$select_query = "SELECT * FROM ".$GLOBALS['lr_table']." WHERE ".$where." AND deleted = '0' AND godown_id != 0 ORDER BY id DESC";	
			}
			else
			{
				$select_query = "SELECT * FROM ".$GLOBALS['lr_table']." WHERE  deleted = '0'  ORDER BY id DESC";	
			}
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['lr_table'], $select_query);
			}
			return $list;
		}
		public function getTripsheetLuggage()
		{
			$luggagesheet_list = array(); $from_date = ""; $to_date = "";
			if(isset($_SESSION['billing_year_starting_date']) && !empty($_SESSION['billing_year_starting_date'])) {
				$from_date = $_SESSION['billing_year_starting_date'];
				if(!empty($from_date)) {
					$from_date = date("Y-m-d", strtotime($from_date));
				}
			}			
			if(isset($_SESSION['billing_year_ending_date']) && !empty($_SESSION['billing_year_ending_date'])) {
				$to_date = $_SESSION['billing_year_ending_date'];
				if(!empty($to_date)) {
					$to_date = date("Y-m-d", strtotime($to_date));
				}
			}
			if(!empty($from_date) && !empty($to_date)) {
				$select_query = "SELECT * FROM ".$GLOBALS['luggagesheet_table']." WHERE DATE(luggage_date) >= '".$from_date."' AND DATE(luggage_date) <= '".$to_date."' 
									AND luggagesheet_number != '".$GLOBALS['null_value']."' AND deleted = 0 AND is_cleared = 0 GROUP BY luggagesheet_number";
				$luggagesheet_list = $this->getQueryRecords('',$select_query);
			}
			return $luggagesheet_list;
		}
		public function LrLuggageUpdate($lr_id,$luggagesheet_number) {
			$getUniqueId = $this->getTableColumnValue($GLOBALS['lr_table'],'lr_id',$lr_id,'id');
			$columns = array(); $values = array();          		
			$columns = array('is_luggage_entry','luggagesheet_number');
			$values = array("'1'","'".$luggagesheet_number."'");
			$list = $this->UpdateSQL($GLOBALS['lr_table'], $getUniqueId, $columns, $values,'');
			return $list;
		}
		public function consignorDetails($consignor_id, $table) {
			$bill_company_details = "";
			if(!empty($consignor_id)) {
				$check_consignor = array();
				$check_consignor = $this->getTableRecords($GLOBALS['consignor_table'],'consignor_id',$consignor_id);
				if(!empty($check_consignor)) {
					foreach($check_consignor as $data) {
				
						if(!empty($data['name'])) {
							$bill_company_details = $this->encode_decode('decrypt', $data['name']);
						}
						if(!empty($data['mobile_number']) && $data['mobile_number'] != $GLOBALS['null_value']) {
							$bill_company_details = $bill_company_details."$$$".$this->encode_decode('decrypt', $data['mobile_number']);
						}
						else {
							$bill_company_details = $bill_company_details."$$$".$GLOBALS['null_value'];
						}
						if(!empty($data['identification']) && $data['identification'] != $GLOBALS['null_value']) {
							$bill_company_details = $bill_company_details."$$$".$this->encode_decode('decrypt', $data['identification']);
						}
						else {
							$bill_company_details = $bill_company_details."$$$".$GLOBALS['null_value']."$$$";
						}
						if(!empty($data['address']) && $data['address'] != $GLOBALS['null_value']) {
							$bill_company_details = $bill_company_details."$$$".$this->encode_decode('decrypt', $data['address']);
						}
						else
						{
							$bill_company_details = $bill_company_details."$$$".$GLOBALS['null_value'];
						}
						if(!empty($data['city']) && $data['city'] != $GLOBALS['null_value']) {
							$bill_company_details = $bill_company_details."$$$".$this->encode_decode('decrypt', $data['city']);
						}
						else
						{
							$bill_company_details = $bill_company_details."$$$".$GLOBALS['null_value'];	
						}
						
						if(!empty($data['district']) && $data['district'] != $GLOBALS['null_value']) {
							$bill_company_details = $bill_company_details."$$$".$this->encode_decode('decrypt', $data['district']);
						}
						else
						{
							$bill_company_details = $bill_company_details."$$$".$GLOBALS['null_value'];	
						}

						if(!empty($data['state']) && $data['state'] != $GLOBALS['null_value']) {
							$bill_company_details = $bill_company_details."$$$".$this->encode_decode('decrypt', $data['state']);
						}
						else
						{
							$bill_company_details = $bill_company_details."$$$".$GLOBALS['null_value'];	
						}
						
						if(!empty($data['email']) && $data['email'] != $GLOBALS['null_value']) {
							$bill_company_details = $bill_company_details."$$$".$this->encode_decode('decrypt', $data['email']);
						}
						else {
							$bill_company_details = $bill_company_details."$$$".$GLOBALS['null_value'];
						}
						
					}
				}
				if(!empty($bill_company_details)) {
					$bill_company_details = $this->encode_decode('encrypt', $bill_company_details);
				}
			}
			return $bill_company_details;
		}
		public function consigneeDetails($consignee_id, $table) {
			$bill_company_details = "";
			if(!empty($consignee_id)) {
				$check_consignee = array();
				$check_consignee = $this->getTableRecords($GLOBALS['consignee_table'], 'consignee_id',$consignee_id);
				if(!empty($check_consignee)) {
					foreach($check_consignee as $data) {
				
						if(!empty($data['name'])) {
							$bill_company_details = $this->encode_decode('decrypt', $data['name']);
						}
						if(!empty($data['mobile_number']) && $data['mobile_number'] != $GLOBALS['null_value']) {
							$bill_company_details = $bill_company_details."$$$".$this->encode_decode('decrypt', $data['mobile_number']);
						}
						else {
							$bill_company_details = $bill_company_details."$$$".$GLOBALS['null_value'];
						}
						if(!empty($data['identification']) && $data['identification'] != $GLOBALS['null_value']) {
							$bill_company_details = $bill_company_details."$$$".$this->encode_decode('decrypt', $data['identification']);
						}
						else {
							$bill_company_details = $bill_company_details."$$$".$GLOBALS['null_value'];
						}
						if(!empty($data['address']) && $data['address'] != $GLOBALS['null_value']) {
							$bill_company_details = $bill_company_details."$$$".$this->encode_decode('decrypt', $data['address']);
						}
						else
						{
							$bill_company_details = $bill_company_details."$$$".$GLOBALS['null_value'];
						}
						if(!empty($data['city']) && $data['city'] != $GLOBALS['null_value']) {
							$bill_company_details = $bill_company_details."$$$".$this->encode_decode('decrypt', $data['city']);
						}
						else
						{
							$bill_company_details = $bill_company_details."$$$".$GLOBALS['null_value'];
						}
						if(!empty($data['district']) && $data['district'] != $GLOBALS['null_value']) {
							$bill_company_details = $bill_company_details."$$$".$this->encode_decode('decrypt', $data['district']);
						}
						else
						{
							$bill_company_details = $bill_company_details."$$$".$GLOBALS['null_value'];	
						}
						if(!empty($data['state']) && $data['state'] != $GLOBALS['null_value']) {
							$bill_company_details = $bill_company_details."$$$".$this->encode_decode("decrypt",$data['state']);
						}
						else {
							$bill_company_details = $bill_company_details."$$$".$GLOBALS['null_value'];
						}
						if(!empty($data['email']) && $data['email'] != $GLOBALS['null_value']) {
							$bill_company_details = $bill_company_details."$$$".$this->encode_decode('decrypt', $data['email']);
						}
						else {
							$bill_company_details = $bill_company_details."$$$".$GLOBALS['null_value'];
						}
						
					}
				}
				if(!empty($bill_company_details)) {
					$bill_company_details = $this->encode_decode('encrypt', $bill_company_details);
				}
			}
			return $bill_company_details;
		}
		public function accountpartyDetails($account_party_id, $table) {
			$bill_company_details = "";
			if(!empty($account_party_id)) {
				$check_account_party = array();
				$check_account_party = $this->getTableRecords($GLOBALS['account_party_table'], 'account_party_id',$account_party_id);
				if(!empty($check_account_party)) {
					foreach($check_account_party as $data) {
				
						if(!empty($data['name'])) {
							$bill_company_details = $this->encode_decode('decrypt', $data['name']);
						}
						if(!empty($data['address']) && $data['address'] != $GLOBALS['null_value']) {
							$bill_company_details = $bill_company_details."$$$".$this->encode_decode('decrypt', $data['address']);
						}
						else
						{
							$bill_company_details = $bill_company_details."$$$".$GLOBALS['null_value'];
						}
						if(!empty($data['state']) && $data['state'] != $GLOBALS['null_value']) {
							$bill_company_details = $bill_company_details."$$$".$this->encode_decode("decrypt",$data['state']);
						}
						else {
							$bill_company_details = $bill_company_details."$$$".$GLOBALS['null_value'];
						}
						if(!empty($data['city']) && $data['city'] != $GLOBALS['null_value']) {
							$bill_company_details = $bill_company_details."$$$".$this->encode_decode('decrypt', $data['city']);
						}
						else
						{
							$bill_company_details = $bill_company_details."$$$".$GLOBALS['null_value'];
						}
						if(!empty($data['mobile_number']) && $data['mobile_number'] != $GLOBALS['null_value']) {
							$bill_company_details = $bill_company_details."$$$".$this->encode_decode('decrypt', $data['mobile_number']);
						}
						else {
							$bill_company_details = $bill_company_details."$$$".$GLOBALS['null_value'];
						}
						if(!empty($data['email']) && $data['email'] != $GLOBALS['null_value']) {
							$bill_company_details = $bill_company_details."$$$".$this->encode_decode('decrypt', $data['email']);
						}
						else {
							$bill_company_details = $bill_company_details."$$$".$GLOBALS['null_value'];
						}
						if(!empty($data['identification']) && $data['identification'] != $GLOBALS['null_value']) {
							$bill_company_details = $bill_company_details."$$$".$this->encode_decode('decrypt', $data['identification']);
						}
						else {
							$bill_company_details = $bill_company_details."$$$".$GLOBALS['null_value'].'$$$';
						}
					}
				}
				if(!empty($bill_company_details)) {
					$bill_company_details = $this->encode_decode('encrypt', $bill_company_details);
				}
			}
			return $bill_company_details;
		}
		public function vehicleDetails($vehicle_id, $table) {
			$bill_company_details = "";
			if(!empty($vehicle_id)) {
				$check_vehicle = array();
				$check_vehicle = $this->getTableRecords($GLOBALS['vehicle_table'], 'vehicle_id',$vehicle_id);
				if(!empty($check_vehicle)) {
					foreach($check_vehicle as $data) {
				
						if(!empty($data['name'])) {
							$bill_company_details = $this->encode_decode('decrypt', $data['name']);
						}
						if(!empty($data['mobile_number']) && $data['mobile_number'] != $GLOBALS['null_value']) {
							$bill_company_details = $bill_company_details."$$$".$this->encode_decode('decrypt', $data['mobile_number']);
						}
						else {
							$bill_company_details = $bill_company_details."$$$".$GLOBALS['null_value'];
						}
						
						if(!empty($data['vehicle_number']) && $data['vehicle_number'] != $GLOBALS['null_value']) {
							$bill_company_details = $bill_company_details."$$$".$this->encode_decode('decrypt', $data['vehicle_number']);
						}
						else {
							$bill_company_details = $bill_company_details."$$$".$GLOBALS['null_value'];
						}
					}
				}
				if(!empty($bill_company_details)) {
					$bill_company_details = $this->encode_decode('encrypt', $bill_company_details);
				}
			}
			return $bill_company_details;
		}
		public function getAckReportList($organization_id,$consignor_id,$branch_id,$from_date,$to_date) {
			$list = array(); $select_query = ""; $where = "";

			// if(!empty($bill_company_id)) {
			// 	$where = "bill_company_id = '".$bill_company_id."'";
			// }
			if(!empty($bill_type)) {
				if(!empty($where)) {
					$where = $where." AND bill_type = '".$bill_type."'";
				}
				else {
					$where = "bill_type = '".$bill_type."'";
				}
			}
			if(!empty($organization_id)) {
				if(!empty($where)) {
					$where = $where." AND organization_id = '".$organization_id."'";
				}
				else {
					$where = "organization_id = '".$organization_id."'";
				}
			}
			if(!empty($consignee_id)) {
				if(!empty($where)) {
					$where = $where." AND consignee_id = '".$consignee_id."'";
				}
				else {
					$where = "consignee_id = '".$consignee_id."'";
				}
			}
			if(!empty($branch_id)) {
				$branch_id = "'" . str_replace(",", "','", $branch_id) . "'";
				if(!empty($where)) {
					$where = $where." AND branch_id in (".$branch_id.")";
				}
				else {
					$where = "branch_id in (".$branch_id.")";
				}
			}
			if(!empty($from_date)) {
				$from_date = date("Y-m-d", strtotime($from_date));
				if(!empty($where)) {
					$where = $where." AND invoice_date >= '".$from_date."'";
				}
				else {
					$where = "invoice_date >= '".$from_date."'";
				}
			}
			if(!empty($to_date)) {
				$to_date = date("Y-m-d", strtotime($to_date));
				if(!empty($where)) {
					$where = $where." AND invoice_date <= '".$to_date."'";
				}
				else {
					$where = "invoice_date <= '".$to_date."'";
				}
			}

			if(!empty($where)) {
			$select_query = "SELECT * FROM ".$GLOBALS['invoice_table']." WHERE ".$where." AND is_acknowledged = '1' AND deleted = '0'  ORDER BY id DESC";	
			}
			else
			{
				$select_query = "SELECT * FROM ".$GLOBALS['invoice_table']." WHERE  is_acknowledged='1' AND	 deleted = '0'  ORDER BY id DESC";	
			}
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['invoice_table'], $select_query);
			}
			return $list;
		}
		public function getClLRReportList($organization_id,$consignor_id,$consignee_id,$branch_id,$bill_type,$from_date,$to_date) {
			$list = array(); $select_query = ""; $where = "";

			// if(!empty($bill_company_id)) {
			// 	$where = "bill_company_id = '".$bill_company_id."'";
			// }
			if(!empty($bill_type)) {
				if(!empty($where)) {
					$where = $where." AND bill_type = '".$bill_type."'";
				}
				else {
					$where = "bill_type = '".$bill_type."'";
				}
			}
			if(!empty($consignee_id)) {
				if(!empty($where)) {
					$where = $where." AND consignee_id = '".$consignee_id."'";
				}
				else {
					$where = "consignee_id = '".$consignee_id."'";
				}
			}
			if(!empty($organization_id)) {
				if(!empty($where)) {
					$where = $where." AND organization_id = '".$organization_id."'";
				}
				else {
					$where = "organization_id = '".$organization_id."'";
				}
			}
			if(!empty($consignor_id)) {
				if(!empty($where)) {
					$where = $where." AND consignor_id = '".$consignor_id."'";
				}
				else {
					$where = "consignor_id = '".$consignor_id."'";
				}
			}
			if(!empty($branch_id)) {
				$branch_id = "'" . str_replace(",", "','", $branch_id) . "'";
				if(!empty($where)) {
					$where = $where." AND branch_id in(".$branch_id.")";
				}
				else {
					$where = "branch_id in(".$branch_id.")";
				}
			}
			if(!empty($from_date)) {
				$from_date = date("Y-m-d", strtotime($from_date));
				if(!empty($where)) {
					$where = $where." AND lr_date >= '".$from_date."'";
				}
				else {
					$where = "lr_date >= '".$from_date."'";
				}
			}
			if(!empty($to_date)) {
				$to_date = date("Y-m-d", strtotime($to_date));
				if(!empty($where)) {
					$where = $where." AND lr_date <= '".$to_date."'";
				}
				else {
					$where = "lr_date <= '".$to_date."'";
				}
			}

			if(!empty($where)) {
				$select_query = "SELECT * FROM ".$GLOBALS['lr_table']." WHERE ".$where." AND is_cleared = '1' AND deleted = '0'  ORDER BY id DESC";	
			}
			else
			{
				$select_query = "SELECT * FROM ".$GLOBALS['lr_table']." WHERE  is_cleared='1' AND	 deleted = '0'  ORDER BY id DESC";	
			}
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['lr_table'], $select_query);
			}
			return $list;
		}
		public function getUnClLRReportList($organization_id,$consignor_id,$consignee_id,$branch_id,$bill_type,$from_date,$to_date,$lr_number) {
			$list = array(); $select_query = ""; $where = "";

			// if(!empty($bill_company_id)) {
			// 	$where = "bill_company_id = '".$bill_company_id."'";
			// }
			if(!empty($bill_type)) {
				if(!empty($where)) {
					$where = $where." AND bill_type = '".$bill_type."'";
				}
				else {
					$where = "bill_type = '".$bill_type."'";
				}
			}
			if(!empty($organization_id)) {
				if(!empty($where)) {
					$where = $where." AND organization_id = '".$organization_id."'";
				}
				else {
					$where = "organization_id = '".$organization_id."'";
				}
			}
			if(!empty($consignee_id)) {
				if(!empty($where)) {
					$where = $where." AND consignee_id = '".$consignee_id."'";
				}
				else {
					$where = "consignee_id = '".$consignee_id."'";
				}
			}
			if(!empty($consignor_id)) {
				if(!empty($where)) {
					$where = $where." AND consignor_id = '".$consignor_id."'";
				}
				else {
					$where = "consignor_id = '".$consignor_id."'";
				}
			}
			if(!empty($branch_id)) {
				$branch_id = "'" . str_replace(",", "','", $branch_id) . "'";
				if(!empty($where)) {
					$where = $where." AND branch_id in (".$branch_id.")";
				}
				else {
					$where = "branch_id in (".$branch_id.")";
				}
			}
			if(!empty($lr_number)) {
				if(!empty($where)) {
					$where = $where." AND lr_number = '".$lr_number."'";
				}
				else {
					$where = "lr_number = '".$lr_number."'";
				}
			}
			if(!empty($from_date)) {
				$from_date = date("Y-m-d", strtotime($from_date));
				if(!empty($where)) {
					$where = $where." AND lr_date >= '".$from_date."'";
				}
				else {
					$where = "lr_date >= '".$from_date."'";
				}
			}
			if(!empty($to_date)) {
				$to_date = date("Y-m-d", strtotime($to_date));
				if(!empty($where)) {
					$where = $where." AND lr_date <= '".$to_date."'";
				}
				else {
					$where = "lr_date <= '".$to_date."'";
				}
			}

			if(!empty($where)) {
				$select_query = "SELECT * FROM ".$GLOBALS['lr_table']." WHERE ".$where." AND is_cleared = '0' AND deleted = '0'  ORDER BY id DESC";	
			}
			else
			{
				$select_query = "SELECT * FROM ".$GLOBALS['lr_table']." WHERE  is_cleared='0' AND	 deleted = '0'  ORDER BY id DESC";	
			}
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['lr_table'], $select_query);
			}
			return $list;
		}
		public function CheckPrivateMarkNameAlreadyExists($private_mark_name) {
			$list = array(); $select_query = ""; $id = "";
			if(!empty($private_mark_name)) {
				$select_query = "SELECT id FROM ".$GLOBALS['private_mark_table']." WHERE lower_case_name = '".$private_mark_name."' AND deleted = '0'";	
			}
			
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['private_mark_table'], $select_query);
				if(!empty($list)) {
					foreach($list as $data) {
						if(!empty($data['id'])) {
							$id = $data['id'];
						}
					}
				}
			}
			return $id;
		}
		public function getReceiptList($company_id, $from_date, $to_date,$gcno) {
			$list = array(); $select_query = ""; $where = "";

			if(!empty($company_id)) {
				$where = "company_id = '".$company_id."'";
			}
			
			if(!empty($filter_party_id)) {
				if(!empty($where)) {
					$where = $where." AND (agent_id = '".$filter_party_id."' || sales_party_id = '".$filter_party_id."') ";
				}
				else {
					$where = "sales_party_id = '".$filter_party_id."'";
				}
			}
			if(!empty($from_date)) {
				$from_date = date("Y-m-d", strtotime($from_date));
				if(!empty($where)) {
					$where = $where." AND receipt_date >= '".$from_date."'";
				}
				else {
					$where = "receipt_date >= '".$from_date."'";
				}
			}
			
			if(!empty($to_date)) {
				$to_date = date("Y-m-d", strtotime($to_date));
				if(!empty($where)) {
					$where = $where." AND receipt_date <= '".$to_date."'";
				}
				else {
					$where = "receipt_date <= '".$to_date."'";
				}
			}
			if(!empty($gcno)) {
				if(!empty($where)) {
					$where = $where." AND receipt_id NOT IN (".$gcno." )";
				}
				else {
					$where = "receipt_id NOT IN (".$gcno.") ";
				}
			}
			if(!empty($where)) {
				$select_query = "SELECT * FROM ".$GLOBALS['receipt_table']." WHERE ".$where."  ORDER BY id DESC";	
			}
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['receipt_table'], $select_query);
			}
			return $list;
		}
		
		public function getReceiptList1($company_id, $from_date, $to_date,$gcno) {
			$list = array(); $select_query = ""; $where = "";

			if(!empty($company_id)) {
				$where = "company_id = '".$company_id."'";
			}
			
			if(!empty($filter_party_id)) {
				if(!empty($where)) {
					$where = $where." AND (agent_id = '".$filter_party_id."' || sales_party_id = '".$filter_party_id."') ";
				}
				else {
					$where = "sales_party_id = '".$filter_party_id."'";
				}
			}
			if(!empty($from_date)) {
				$from_date = date("Y-m-d", strtotime($from_date));
				if(!empty($where)) {
					$where = $where." AND receipt_date >= '".$from_date."'";
				}
				else {
					$where = "receipt_date >= '".$from_date."'";
				}
			}
			
			if(!empty($to_date)) {
				$to_date = date("Y-m-d", strtotime($to_date));
				if(!empty($where)) {
					$where = $where." AND receipt_date <= '".$to_date."'";
				}
				else {
					$where = "receipt_date <= '".$to_date."'";
				}
			}
			if(!empty($gcno)) {
				if(!empty($where)) {
					$where = $where." AND receipt_id NOT IN (".$gcno." )";
				}
				else {
					$where = "receipt_id NOT IN (".$gcno.") ";
				}
			}
			if(!empty($where)) {
				$select_query = "SELECT * FROM ".$GLOBALS['receipt_table']." WHERE ".$where." AND deleted = '0' ORDER BY id DESC";	
			}
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['receipt_table'], $select_query);
			}
			return $list;
		}
		public function getInvoiceList( $company_id, $from_date, $to_date) {
			$list = array(); $select_query = ""; $where = "";

			if(!empty($company_id)) {
				$where = "company_id = '".$company_id."'";
			}
			
			if(!empty($from_date)) {
				$from_date = date("Y-m-d", strtotime($from_date));
				if(!empty($where)) {
					$where = $where." AND invoice_date >= '".$from_date."'";
				}
				else {
					$where = "invoice_date >= '".$from_date."'";
				}
			}
			
			if(!empty($to_date)) {
				$to_date = date("Y-m-d", strtotime($to_date));
				if(!empty($where)) {
					$where = $where." AND invoice_date <= '".$to_date."'";
				}
				else {
					$where = "invoice_date <= '".$to_date."'";
				}
			}

			if(!empty($where)) {
				$select_query = "SELECT * FROM ".$GLOBALS['invoice_table']." WHERE ".$where." AND deleted = '0' ORDER BY id DESC";	
			}
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['invoice_table'], $select_query);
			}
			return $list;
		}

		public function getClearanceList() {
			$list = array(); $select_query = ""; $where = "";
	
			$select_query = "SELECT * FROM ".$GLOBALS['invoice_table']." WHERE cleared = '' AND deleted = '0' ORDER BY id DESC";
	
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['invoice_table'], $select_query);
			}
			return $list;
		}

		public function getStockList($gcno) {
			$list = array(); $select_query = ""; $where = "";
	
			$select_query = "SELECT sum(receipt_quantity) receipt_quantity, sum(invoice_quantity) invoice_quantity FROM ".$GLOBALS['stock_table']." WHERE gcno='".$gcno."' AND deleted = '0' ORDER BY id DESC";
	
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['invoice_table'], $select_query);
			}
			return $list;
		}

		public function getStockReport($from_date , $to_date, $company_id) {
			$list = array(); $select_query = ""; $where = "";

			if(!empty($from_date)) {
				$from_date = date("Y-m-d", strtotime($from_date));
				if(!empty($where)) {
					$where = $where." receipt_date >= '".$from_date."' AND";
				}
				else {
					$where = "receipt_date >= '".$from_date."' AND";
				}
			}
			
			if(!empty($to_date)) {
				$to_date = date("Y-m-d", strtotime($to_date));
				if(!empty($where)) {
					$where = $where." receipt_date <= '".$to_date."' AND ";
				}
				else {
					$where = "receipt_date <= '".$to_date."' AND ";
				}
			}

			if(!empty($company_id)){
				$where .= "company_id = '".$company_id."' AND ";
			}
	
			$select_query = "SELECT distinct st.gcno ,sum(receipt_quantity) receipt_quantity, sum(invoice_quantity) invoice_quantity, receipt_date, consignor_id, consignee_id, company_id, unit_id, consignee_city,private_mark,gst_option,quantity,rate FROM ".$GLOBALS['stock_table']." st INNER JOIN ".$GLOBALS['receipt_table']." rt WHERE ".$where." st.deleted = '0' and rt.deleted = '0' and st.gcno = rt.gcno group by gcno, unit_id HAVING SUM(receipt_quantity-invoice_quantity) > 0 ORDER BY st.id DESC";

			// $select_query = "SELECT distinct s.gcno, cne_client_name, consignee_city from ".$GLOBALS['stock_table']." s, ".$GLOBALS['receipt_table']." r where s.deleted = '0' and s.deleted = r.deleted and s.gcno=r.gcno GROUP by gcno HAVING SUM(receipt_quantity-invoice_quantity) > 0";
	
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['stock_table'], $select_query);
			}
			return $list;
		}

		public function StockCheck($gc_no , $unit_id) {
			$list = array(); $select_query = ""; $where = "";

			$select_query = "SELECT gcno, id, invoice_quantity from ".$GLOBALS['stock_table']." where gcno='".$gc_no."' and unit_id = '".$unit_id."' and deleted = '0' ";
	
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['stock_table'], $select_query);
			}
			return $list;
		}

		public function getReceiptQuantity($gc_no ) {
			$list = array(); $select_query = ""; $where = "";

			$select_query = "SELECT quantity, content, rate from ".$GLOBALS['receipt_table']." where gcno='".$gc_no."' ";
	
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['receipt_table'], $select_query);
			}
			return $list;
		}

		public function getConsigneeCity() {
			$list = array(); $select_query = ""; $where = "";

			$select_query = "SELECT distinct consignee_city from ".$GLOBALS['receipt_table']." where deleted = '0' ";
	
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['receipt_table'], $select_query);
			}
			return $list;
		}

		public function getLRList(){
			$select_query = ""; $list = array();
			$select_query = "SELECT distinct s.gcno from ".$GLOBALS['stock_table']." s where s.deleted = '0' GROUP by gcno HAVING SUM(receipt_quantity-invoice_quantity) > 0";
			if(!empty($select_query)){
				$list = $this->getQueryRecords($GLOBALS['stock_table'], $select_query);
			}
			return $list;
		}
		public function getLRDetailsById($tripsheet_id){
			$tripsheet_list = array();
			if(!empty($tripsheet_id)) {
				$tripsheet_number = ""; $trip_lr_ids = "";

				$tripsheet_list = array();
				$tripsheet_list = $this->getTableRecords($GLOBALS['tripsheet_table'], 'tripsheet_id', $tripsheet_id);
				if(!empty($tripsheet_list)) {
					foreach($tripsheet_list as $data) {
						if(!empty($data['tripsheet_number'])) { $tripsheet_number =  $data['tripsheet_number']; }
						if(!empty($data['lr_id'])) { $trip_lr_ids = $data['lr_id']; }						
					}
				}

				if(!empty($tripsheet_number) && !empty($trip_lr_ids)) {
					$select_query = "SELECT * FROM ".$GLOBALS['lr_table']." WHERE FIND_IN_SET(lr_id, '".$trip_lr_ids."') AND deleted = '0' ORDER BY branch_id";
					$tripsheet_list = $this->getQueryRecords('',$select_query);
				}
			}
			return $tripsheet_list;
		}
    }

	
?>